/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.proxy.msg.Asn1RSAPkcsPssParams;

public class Asn1P11Params
extends ASN1Object {
    private final ASN1Encodable p11Params;

    public Asn1P11Params(ASN1Encodable p11Params) {
        this.p11Params = (ASN1Encodable)ParamUtil.requireNonNull((String)"p11Params", (Object)p11Params);
    }

    private Asn1P11Params(ASN1TaggedObject taggedObject) throws BadAsn1ObjectException {
        int tagNo = taggedObject.getTagNo();
        if (tagNo != 0) {
            throw new BadAsn1ObjectException("invalid tag " + tagNo);
        }
        this.p11Params = Asn1RSAPkcsPssParams.getInstance(taggedObject.getObject());
    }

    public static Asn1P11Params getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1P11Params) {
            return (Asn1P11Params)((Object)obj);
        }
        try {
            if (obj instanceof ASN1TaggedObject) {
                return new Asn1P11Params((ASN1TaggedObject)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1P11Params.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        if (!(this.p11Params instanceof Asn1RSAPkcsPssParams)) {
            throw new RuntimeException("invalid ASN1P11Param type " + this.p11Params.getClass().getName());
        }
        int tagNo = 0;
        return new DERTaggedObject(tagNo, this.p11Params);
    }

    public ASN1Encodable p11Params() {
        return this.p11Params;
    }
}

