/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;

public class AlgorithmUtil {
    private static final Map<String, AlgorithmCode> algNameCodeMap;
    private static final List<String> curveNames;
    private static final Map<String, ASN1ObjectIdentifier> curveNameOidMap;

    private AlgorithmUtil() {
    }

    public static ASN1ObjectIdentifier getHashAlg(String hashAlgName) throws NoSuchAlgorithmException {
        ParamUtil.requireNonNull((String)"hashAlgName", (Object)hashAlgName);
        HashAlgoType hashAlgo = HashAlgoType.getHashAlgoType(hashAlgName);
        if (hashAlgo == null) {
            throw new NoSuchAlgorithmException("Unsupported hash algorithm " + hashAlgName);
        }
        return hashAlgo.oid();
    }

    public static int getHashOutputSizeInOctets(ASN1ObjectIdentifier hashAlgo) throws NoSuchAlgorithmException {
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)hashAlgo);
        HashAlgoType hashAlgoType = HashAlgoType.getHashAlgoType(hashAlgo);
        if (hashAlgoType == null) {
            throw new NoSuchAlgorithmException("Unsupported hash algorithm " + hashAlgo.getId());
        }
        return hashAlgoType.length();
    }

    public static AlgorithmCode getSigOrMacAlgoCode(AlgorithmIdentifier algId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        AlgorithmCode code = algNameCodeMap.get(oid.getId());
        if (code != null) {
            return code;
        }
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)oid)) {
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)algId.getParameters());
            ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
            if (X509ObjectIdentifiers.id_SHA1.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA1WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha224.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA224WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha256.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA256WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha384.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA384WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha512.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA512WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha3_224.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA3_224WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha3_256.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA3_256WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha3_384.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA3_384WITHRSAANDMGF1;
            }
            if (NISTObjectIdentifiers.id_sha3_512.equals((Object)digestAlgOid)) {
                return AlgorithmCode.SHA3_512WITHRSAANDMGF1;
            }
            throw new NoSuchAlgorithmException("unsupported digest algorithm " + digestAlgOid.getId());
        }
        throw new NoSuchAlgorithmException("unsupported signature algorithm " + oid.getId());
    }

    public static String getSigOrMacAlgoName(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ParamUtil.requireNonNull((String)"sigAlgId", (Object)sigAlgId);
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (NISTObjectIdentifiers.id_aes128_GCM.equals((Object)algOid)) {
            return "AES128GMAC";
        }
        if (NISTObjectIdentifiers.id_aes192_GCM.equals((Object)algOid)) {
            return "AES192GMAC";
        }
        if (NISTObjectIdentifiers.id_aes256_GCM.equals((Object)algOid)) {
            return "AES256GMAC";
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA1.equals((Object)algOid)) {
            return "HMACSHA1";
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA224.equals((Object)algOid)) {
            return "HMACSHA224";
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA256.equals((Object)algOid)) {
            return "HMACSHA256";
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA384.equals((Object)algOid)) {
            return "HMACSHA384";
        }
        if (PKCSObjectIdentifiers.id_hmacWithSHA512.equals((Object)algOid)) {
            return "HMACSHA512";
        }
        if (NISTObjectIdentifiers.id_hmacWithSHA3_224.equals((Object)algOid)) {
            return "HMACSHA3-224";
        }
        if (NISTObjectIdentifiers.id_hmacWithSHA3_256.equals((Object)algOid)) {
            return "HMACSHA3-256";
        }
        if (NISTObjectIdentifiers.id_hmacWithSHA3_384.equals((Object)algOid)) {
            return "HMACSHA3-384";
        }
        if (NISTObjectIdentifiers.id_hmacWithSHA3_512.equals((Object)algOid)) {
            return "HMACSHA3-512";
        }
        return AlgorithmUtil.getSignatureAlgoName(sigAlgId);
    }

    public static String getSignatureAlgoName(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ParamUtil.requireNonNull((String)"sigAlgId", (Object)sigAlgId);
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (X9ObjectIdentifiers.ecdsa_with_SHA1.equals((Object)algOid)) {
            return "SHA1withECDSA";
        }
        if (X9ObjectIdentifiers.ecdsa_with_SHA224.equals((Object)algOid)) {
            return "SHA224withECDSA";
        }
        if (X9ObjectIdentifiers.ecdsa_with_SHA256.equals((Object)algOid)) {
            return "SHA256withECDSA";
        }
        if (X9ObjectIdentifiers.ecdsa_with_SHA384.equals((Object)algOid)) {
            return "SHA384withECDSA";
        }
        if (X9ObjectIdentifiers.ecdsa_with_SHA512.equals((Object)algOid)) {
            return "SHA512withECDSA";
        }
        if (NISTObjectIdentifiers.id_ecdsa_with_sha3_224.equals((Object)algOid)) {
            return "SHA3-224withECDSA";
        }
        if (NISTObjectIdentifiers.id_ecdsa_with_sha3_256.equals((Object)algOid)) {
            return "SHA3-256withECDSA";
        }
        if (NISTObjectIdentifiers.id_ecdsa_with_sha3_384.equals((Object)algOid)) {
            return "SHA3-384withECDSA";
        }
        if (NISTObjectIdentifiers.id_ecdsa_with_sha3_512.equals((Object)algOid)) {
            return "SHA3-512withECDSA";
        }
        if (BSIObjectIdentifiers.ecdsa_plain_SHA1.equals((Object)algOid)) {
            return "SHA1withPLAIN-ECDSA";
        }
        if (BSIObjectIdentifiers.ecdsa_plain_SHA224.equals((Object)algOid)) {
            return "SHA224withPLAIN-ECDSA";
        }
        if (BSIObjectIdentifiers.ecdsa_plain_SHA256.equals((Object)algOid)) {
            return "SHA256withPLAIN-ECDSA";
        }
        if (BSIObjectIdentifiers.ecdsa_plain_SHA384.equals((Object)algOid)) {
            return "SHA384withPLAIN-ECDSA";
        }
        if (BSIObjectIdentifiers.ecdsa_plain_SHA512.equals((Object)algOid)) {
            return "SHA512withPLAIN-ECDSA";
        }
        if (X9ObjectIdentifiers.id_dsa_with_sha1.equals((Object)algOid)) {
            return "SHA1withDSA";
        }
        if (NISTObjectIdentifiers.dsa_with_sha224.equals((Object)algOid)) {
            return "SHA224withDSA";
        }
        if (NISTObjectIdentifiers.dsa_with_sha256.equals((Object)algOid)) {
            return "SHA256withDSA";
        }
        if (NISTObjectIdentifiers.dsa_with_sha384.equals((Object)algOid)) {
            return "SHA384withDSA";
        }
        if (NISTObjectIdentifiers.dsa_with_sha512.equals((Object)algOid)) {
            return "SHA512withDSA";
        }
        if (NISTObjectIdentifiers.id_dsa_with_sha3_224.equals((Object)algOid)) {
            return "SHA3-224withDSA";
        }
        if (NISTObjectIdentifiers.id_dsa_with_sha3_256.equals((Object)algOid)) {
            return "SHA3-256withDSA";
        }
        if (NISTObjectIdentifiers.id_dsa_with_sha3_384.equals((Object)algOid)) {
            return "SHA3-384withDSA";
        }
        if (NISTObjectIdentifiers.id_dsa_with_sha3_512.equals((Object)algOid)) {
            return "SHA3-512withDSA";
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.equals((Object)algOid)) {
            return "SHA1withRSA";
        }
        if (PKCSObjectIdentifiers.sha224WithRSAEncryption.equals((Object)algOid)) {
            return "SHA224withRSA";
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.equals((Object)algOid)) {
            return "SHA256withRSA";
        }
        if (PKCSObjectIdentifiers.sha384WithRSAEncryption.equals((Object)algOid)) {
            return "SHA384withRSA";
        }
        if (PKCSObjectIdentifiers.sha512WithRSAEncryption.equals((Object)algOid)) {
            return "SHA512withRSA";
        }
        if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.equals((Object)algOid)) {
            return "SHA3-224withRSA";
        }
        if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.equals((Object)algOid)) {
            return "SHA3-256withRSA";
        }
        if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.equals((Object)algOid)) {
            return "SHA3-384withRSA";
        }
        if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.equals((Object)algOid)) {
            return "SHA3-512withRSA";
        }
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)sigAlgId.getParameters());
            ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
            if (X509ObjectIdentifiers.id_SHA1.equals((Object)digestAlgOid)) {
                return "SHA1withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha224.equals((Object)digestAlgOid)) {
                return "SHA224withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha256.equals((Object)digestAlgOid)) {
                return "SHA256withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha384.equals((Object)digestAlgOid)) {
                return "SHA384withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha512.equals((Object)digestAlgOid)) {
                return "SHA512withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha3_224.equals((Object)digestAlgOid)) {
                return "SHA3-224withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha3_256.equals((Object)digestAlgOid)) {
                return "SHA3-256withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha3_384.equals((Object)digestAlgOid)) {
                return "SHA3-384withRSAandMGF1";
            }
            if (NISTObjectIdentifiers.id_sha3_512.equals((Object)digestAlgOid)) {
                return "SHA3-512withRSAandMGF1";
            }
            throw new NoSuchAlgorithmException("unsupported digest algorithm " + digestAlgOid.getId());
        }
        throw new NoSuchAlgorithmException("unsupported signature algorithm " + algOid.getId());
    }

    public static boolean isDSAPlainSigAlg(AlgorithmIdentifier algId) {
        return AlgorithmUtil.isPlainECDSASigAlg(algId);
    }

    public static String canonicalizeSignatureAlgo(String algoName) throws NoSuchAlgorithmException {
        return AlgorithmUtil.getSignatureAlgoName(AlgorithmUtil.getSigAlgId(algoName));
    }

    public static AlgorithmIdentifier getMacAlgId(String macAlgName) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier oid;
        ParamUtil.requireNonNull((String)"macAlgName", (Object)macAlgName);
        String algoS = macAlgName.toUpperCase();
        if (algoS.indexOf(45) != -1 && algoS.indexOf("SHA3-") == -1) {
            algoS = algoS.replaceAll("-", "");
        }
        if ("HMACSHA1".equals(algoS)) {
            oid = PKCSObjectIdentifiers.id_hmacWithSHA1;
        } else if ("HMACSHA224".equals(algoS)) {
            oid = PKCSObjectIdentifiers.id_hmacWithSHA224;
        } else if ("HMACSHA256".equals(algoS)) {
            oid = PKCSObjectIdentifiers.id_hmacWithSHA256;
        } else if ("HMACSHA384".equals(algoS)) {
            oid = PKCSObjectIdentifiers.id_hmacWithSHA384;
        } else if ("HMACSHA512".equals(algoS)) {
            oid = PKCSObjectIdentifiers.id_hmacWithSHA512;
        } else if ("HMACSHA3-224".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_hmacWithSHA3_224;
        } else if ("HMACSHA3-256".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_hmacWithSHA3_256;
        } else if ("HMACSHA3-384".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_hmacWithSHA3_384;
        } else if ("HMACSHA3-512".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_hmacWithSHA3_512;
        } else if ("AES128GMAC".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_aes128_GCM;
        } else if ("AES192GMAC".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_aes192_GCM;
        } else if ("AES256GMAC".equals(algoS)) {
            oid = NISTObjectIdentifiers.id_aes256_GCM;
        } else {
            throw new NoSuchAlgorithmException("unsupported signature algorithm " + algoS);
        }
        return new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static AlgorithmIdentifier getHmacAlgId(HashAlgoType hashAlgo) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier oid;
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        switch (hashAlgo) {
            case SHA1: {
                oid = PKCSObjectIdentifiers.id_hmacWithSHA1;
                break;
            }
            case SHA224: {
                oid = PKCSObjectIdentifiers.id_hmacWithSHA224;
                break;
            }
            case SHA256: {
                oid = PKCSObjectIdentifiers.id_hmacWithSHA256;
                break;
            }
            case SHA384: {
                oid = PKCSObjectIdentifiers.id_hmacWithSHA384;
                break;
            }
            case SHA512: {
                oid = PKCSObjectIdentifiers.id_hmacWithSHA512;
                break;
            }
            case SHA3_224: {
                oid = NISTObjectIdentifiers.id_hmacWithSHA3_224;
                break;
            }
            case SHA3_256: {
                oid = NISTObjectIdentifiers.id_hmacWithSHA3_256;
                break;
            }
            case SHA3_384: {
                oid = NISTObjectIdentifiers.id_hmacWithSHA3_384;
                break;
            }
            case SHA3_512: {
                oid = NISTObjectIdentifiers.id_hmacWithSHA3_512;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("unsupported digest algorithm " + (Object)((Object)hashAlgo));
            }
        }
        return new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static AlgorithmIdentifier getSigAlgId(String sigAlgName) throws NoSuchAlgorithmException {
        AlgorithmIdentifier signatureAlgId;
        ParamUtil.requireNonNull((String)"sigAlgName", (Object)sigAlgName);
        String algoS = sigAlgName.toUpperCase();
        if (algoS.indexOf(45) != -1 && algoS.indexOf("SHA3-") == -1) {
            algoS = algoS.replaceAll("-", "");
        }
        if ("SHA1withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA224withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA256withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA384withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA512withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA3-224withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA3-256withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA3-384withRSAandMGF1".equalsIgnoreCase(algoS) || "SHA3-512withRSAandMGF1".equalsIgnoreCase(algoS)) {
            HashAlgoType hashAlgo;
            if ("SHA1withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA1;
            } else if ("SHA224withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA224;
            } else if ("SHA256withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA256;
            } else if ("SHA384withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA384;
            } else if ("SHA512withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA512;
            } else if ("SHA3-224withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA3_224;
            } else if ("SHA3-256withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA3_256;
            } else if ("SHA3-384withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA3_384;
            } else if ("SHA3-512withRSAandMGF1".equalsIgnoreCase(algoS)) {
                hashAlgo = HashAlgoType.SHA3_512;
            } else {
                throw new NoSuchAlgorithmException("should not reach here, unknown algorithm " + algoS);
            }
            signatureAlgId = AlgorithmUtil.buildRSAPSSAlgId(hashAlgo);
        } else {
            ASN1ObjectIdentifier algOid;
            boolean withNullParam = false;
            if ("SHA1withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA1".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha1WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA224withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA224".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha224WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha224WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA256withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA256".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha256WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA384withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA384".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha384WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha384WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA512withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA512".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha512WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA512withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA512".equalsIgnoreCase(algoS) || PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equals(algoS)) {
                algOid = PKCSObjectIdentifiers.sha512WithRSAEncryption;
                withNullParam = true;
            } else if ("SHA3-224withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA3-224".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224;
                withNullParam = true;
            } else if ("SHA3-256withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA3-256".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256;
                withNullParam = true;
            } else if ("SHA3-384withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA3-384".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384;
                withNullParam = true;
            } else if ("SHA3-512withRSA".equalsIgnoreCase(algoS) || "RSAwithSHA3-512".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512;
                withNullParam = true;
            } else if ("SHA1withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA1".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.ecdsa_with_SHA1.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.ecdsa_with_SHA1;
            } else if ("SHA224withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA224".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.ecdsa_with_SHA224.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.ecdsa_with_SHA224;
            } else if ("SHA256withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA256".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.ecdsa_with_SHA256.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.ecdsa_with_SHA256;
            } else if ("SHA384withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA384".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.ecdsa_with_SHA384.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.ecdsa_with_SHA384;
            } else if ("SHA512withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA512".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.ecdsa_with_SHA512.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.ecdsa_with_SHA512;
            } else if ("SHA3-224withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA3-224".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_ecdsa_with_sha3_224.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_224;
            } else if ("SHA3-256withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA3-256".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_ecdsa_with_sha3_256.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_256;
            } else if ("SHA3-384withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA3-384".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_ecdsa_with_sha3_384.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_384;
            } else if ("SHA3-512withECDSA".equalsIgnoreCase(algoS) || "ECDSAwithSHA3-512".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_ecdsa_with_sha3_512.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_512;
            } else if ("SHA1withPlainECDSA".equalsIgnoreCase(algoS) || "PlainECDSAwithSHA1".equalsIgnoreCase(algoS) || BSIObjectIdentifiers.ecdsa_plain_SHA1.getId().equals(algoS)) {
                algOid = BSIObjectIdentifiers.ecdsa_plain_SHA1;
            } else if ("SHA224withPlainECDSA".equalsIgnoreCase(algoS) || "PlainECDSAwithSHA224".equalsIgnoreCase(algoS) || BSIObjectIdentifiers.ecdsa_plain_SHA224.getId().equals(algoS)) {
                algOid = BSIObjectIdentifiers.ecdsa_plain_SHA224;
            } else if ("SHA256withPlainECDSA".equalsIgnoreCase(algoS) || "PlainECDSAwithSHA256".equalsIgnoreCase(algoS) || BSIObjectIdentifiers.ecdsa_plain_SHA256.getId().equals(algoS)) {
                algOid = BSIObjectIdentifiers.ecdsa_plain_SHA256;
            } else if ("SHA384withPlainECDSA".equalsIgnoreCase(algoS) || "PlainECDSAwithSHA384".equalsIgnoreCase(algoS) || BSIObjectIdentifiers.ecdsa_plain_SHA384.getId().equals(algoS)) {
                algOid = BSIObjectIdentifiers.ecdsa_plain_SHA384;
            } else if ("SHA512withPlainECDSA".equalsIgnoreCase(algoS) || "PlainECDSAwithSHA512".equalsIgnoreCase(algoS) || BSIObjectIdentifiers.ecdsa_plain_SHA512.getId().equals(algoS)) {
                algOid = BSIObjectIdentifiers.ecdsa_plain_SHA512;
            } else if ("SHA1withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA1".equalsIgnoreCase(algoS) || X9ObjectIdentifiers.id_dsa_with_sha1.getId().equals(algoS)) {
                algOid = X9ObjectIdentifiers.id_dsa_with_sha1;
            } else if ("SHA224withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA224".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.dsa_with_sha224.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.dsa_with_sha224;
            } else if ("SHA256withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA256".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.dsa_with_sha256.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.dsa_with_sha256;
            } else if ("SHA384withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA384".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.dsa_with_sha384.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.dsa_with_sha384;
            } else if ("SHA512withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA512".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.dsa_with_sha512.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.dsa_with_sha512;
            } else if ("SHA3-224withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA3-224".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_dsa_with_sha3_224.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_dsa_with_sha3_224;
            } else if ("SHA3-256withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA3-256".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_dsa_with_sha3_256.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_dsa_with_sha3_256;
            } else if ("SHA3-384withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA3-384".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_dsa_with_sha3_384.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_dsa_with_sha3_384;
            } else if ("SHA3-512withDSA".equalsIgnoreCase(algoS) || "DSAwithSHA3-512".equalsIgnoreCase(algoS) || NISTObjectIdentifiers.id_dsa_with_sha3_512.getId().equals(algoS)) {
                algOid = NISTObjectIdentifiers.id_dsa_with_sha3_512;
            } else {
                throw new NoSuchAlgorithmException("unsupported signature algorithm " + algoS);
            }
            signatureAlgId = withNullParam ? new AlgorithmIdentifier(algOid, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(algOid);
        }
        return signatureAlgId;
    }

    public static AlgorithmIdentifier getSigAlgId(PublicKey pubKey, SignerConf signerConf) throws NoSuchAlgorithmException {
        boolean dsaPlain;
        ParamUtil.requireNonNull((String)"signerConf", (Object)signerConf);
        if (signerConf.hashAlgo() == null) {
            return AlgorithmUtil.getSigAlgId(signerConf.getConfValue("algo"));
        }
        SignatureAlgoControl algoControl = signerConf.signatureAlgoControl();
        HashAlgoType hashAlgo = signerConf.hashAlgo();
        boolean rsaMgf1 = algoControl == null ? false : algoControl.isRsaMgf1();
        boolean bl = dsaPlain = algoControl == null ? false : algoControl.isDsaPlain();
        if (pubKey instanceof RSAPublicKey) {
            return AlgorithmUtil.getRSASigAlgId(hashAlgo, rsaMgf1);
        }
        if (pubKey instanceof ECPublicKey) {
            return AlgorithmUtil.getECDSASigAlgId(hashAlgo, dsaPlain);
        }
        if (pubKey instanceof DSAPublicKey) {
            return AlgorithmUtil.getDSASigAlgId(hashAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown public key '" + pubKey.getClass().getName());
    }

    public static AlgorithmIdentifier getSigAlgId(PublicKey pubKey, HashAlgoType hashAlgo, SignatureAlgoControl algoControl) throws NoSuchAlgorithmException {
        boolean dsaPlain;
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        boolean rsaMgf1 = algoControl == null ? false : algoControl.isRsaMgf1();
        boolean bl = dsaPlain = algoControl == null ? false : algoControl.isDsaPlain();
        if (pubKey instanceof RSAPublicKey) {
            return AlgorithmUtil.getRSASigAlgId(hashAlgo, rsaMgf1);
        }
        if (pubKey instanceof ECPublicKey) {
            return AlgorithmUtil.getECDSASigAlgId(hashAlgo, dsaPlain);
        }
        if (pubKey instanceof DSAPublicKey) {
            return AlgorithmUtil.getDSASigAlgId(hashAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown public key '" + pubKey.getClass().getName());
    }

    public static boolean isRSASigAlgId(AlgorithmIdentifier algId) {
        ParamUtil.requireNonNull((String)"algId", (Object)algId);
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        return PKCSObjectIdentifiers.sha1WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha224WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha256WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha384WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha512WithRSAEncryption.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.equals((Object)oid) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)oid);
    }

    public static boolean isECSigAlg(AlgorithmIdentifier algId) {
        return AlgorithmUtil.isECDSASigAlg(algId) || AlgorithmUtil.isPlainECDSASigAlg(algId);
    }

    public static boolean isECDSASigAlg(AlgorithmIdentifier algId) {
        ParamUtil.requireNonNull((String)"algId", (Object)algId);
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        return X9ObjectIdentifiers.ecdsa_with_SHA1.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA224.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA256.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA384.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA512.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_512.equals((Object)oid);
    }

    public static boolean isPlainECDSASigAlg(AlgorithmIdentifier algId) {
        ParamUtil.requireNonNull((String)"algId", (Object)algId);
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        return BSIObjectIdentifiers.ecdsa_plain_SHA1.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA224.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA256.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA384.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA512.equals((Object)oid);
    }

    public static boolean isDSASigAlg(AlgorithmIdentifier algId) {
        ParamUtil.requireNonNull((String)"algId", (Object)algId);
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        return X9ObjectIdentifiers.id_dsa_with_sha1.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha224.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha256.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha384.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha512.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_512.equals((Object)oid);
    }

    public static AlgorithmIdentifier getRSASigAlgId(HashAlgoType hashAlgo, boolean mgf1) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier sigAlgOid;
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        if (mgf1) {
            return AlgorithmUtil.buildRSAPSSAlgId(hashAlgo);
        }
        switch (hashAlgo) {
            case SHA1: {
                sigAlgOid = PKCSObjectIdentifiers.sha1WithRSAEncryption;
                break;
            }
            case SHA224: {
                sigAlgOid = PKCSObjectIdentifiers.sha224WithRSAEncryption;
                break;
            }
            case SHA256: {
                sigAlgOid = PKCSObjectIdentifiers.sha256WithRSAEncryption;
                break;
            }
            case SHA384: {
                sigAlgOid = PKCSObjectIdentifiers.sha384WithRSAEncryption;
                break;
            }
            case SHA512: {
                sigAlgOid = PKCSObjectIdentifiers.sha512WithRSAEncryption;
                break;
            }
            case SHA3_224: {
                sigAlgOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224;
                break;
            }
            case SHA3_256: {
                sigAlgOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256;
                break;
            }
            case SHA3_384: {
                sigAlgOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384;
                break;
            }
            case SHA3_512: {
                sigAlgOid = NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512;
                break;
            }
            default: {
                throw new RuntimeException("unknown HashAlgoType: " + (Object)((Object)hashAlgo));
            }
        }
        return new AlgorithmIdentifier(sigAlgOid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static AlgorithmIdentifier getDSASigAlgId(HashAlgoType hashAlgo) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier sigAlgOid;
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        switch (hashAlgo) {
            case SHA1: {
                sigAlgOid = X9ObjectIdentifiers.id_dsa_with_sha1;
                break;
            }
            case SHA224: {
                sigAlgOid = NISTObjectIdentifiers.dsa_with_sha224;
                break;
            }
            case SHA256: {
                sigAlgOid = NISTObjectIdentifiers.dsa_with_sha256;
                break;
            }
            case SHA384: {
                sigAlgOid = NISTObjectIdentifiers.dsa_with_sha384;
                break;
            }
            case SHA512: {
                sigAlgOid = NISTObjectIdentifiers.dsa_with_sha512;
                break;
            }
            case SHA3_224: {
                sigAlgOid = NISTObjectIdentifiers.id_dsa_with_sha3_224;
                break;
            }
            case SHA3_256: {
                sigAlgOid = NISTObjectIdentifiers.id_dsa_with_sha3_256;
                break;
            }
            case SHA3_384: {
                sigAlgOid = NISTObjectIdentifiers.id_dsa_with_sha3_384;
                break;
            }
            case SHA3_512: {
                sigAlgOid = NISTObjectIdentifiers.id_dsa_with_sha3_512;
                break;
            }
            default: {
                throw new RuntimeException("unknown HashAlgoType: " + (Object)((Object)hashAlgo));
            }
        }
        return new AlgorithmIdentifier(sigAlgOid);
    }

    public static AlgorithmIdentifier getECDSASigAlgId(HashAlgoType hashAlgo, boolean plainSignature) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier sigAlgOid;
        block19: {
            block18: {
                ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
                if (!plainSignature) break block18;
                switch (hashAlgo) {
                    case SHA1: {
                        sigAlgOid = BSIObjectIdentifiers.ecdsa_plain_SHA1;
                        break block19;
                    }
                    case SHA224: {
                        sigAlgOid = BSIObjectIdentifiers.ecdsa_plain_SHA224;
                        break block19;
                    }
                    case SHA256: {
                        sigAlgOid = BSIObjectIdentifiers.ecdsa_plain_SHA256;
                        break block19;
                    }
                    case SHA384: {
                        sigAlgOid = BSIObjectIdentifiers.ecdsa_plain_SHA384;
                        break block19;
                    }
                    case SHA512: {
                        sigAlgOid = BSIObjectIdentifiers.ecdsa_plain_SHA512;
                        break block19;
                    }
                    default: {
                        throw new RuntimeException("unknown HashAlgoType: " + (Object)((Object)hashAlgo));
                    }
                }
            }
            switch (hashAlgo) {
                case SHA1: {
                    sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA1;
                    break;
                }
                case SHA224: {
                    sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA224;
                    break;
                }
                case SHA256: {
                    sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA256;
                    break;
                }
                case SHA384: {
                    sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA384;
                    break;
                }
                case SHA512: {
                    sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA512;
                    break;
                }
                case SHA3_224: {
                    sigAlgOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_224;
                    break;
                }
                case SHA3_256: {
                    sigAlgOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_256;
                    break;
                }
                case SHA3_384: {
                    sigAlgOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_384;
                    break;
                }
                case SHA3_512: {
                    sigAlgOid = NISTObjectIdentifiers.id_ecdsa_with_sha3_512;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown HashAlgoType: " + (Object)((Object)hashAlgo));
                }
            }
        }
        return new AlgorithmIdentifier(sigAlgOid);
    }

    public static HashAlgoType extractHashAlgoFromMacAlg(AlgorithmIdentifier macAlg) {
        HashAlgoType hashAlgo;
        ASN1ObjectIdentifier oid = macAlg.getAlgorithm();
        if (PKCSObjectIdentifiers.id_hmacWithSHA1.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA1;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA224.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA224;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA256.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA256;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA384.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA384;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA512.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA512;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_224.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA3_224;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_256.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA3_256;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_384.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA3_384;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_512.equals((Object)oid)) {
            hashAlgo = HashAlgoType.SHA3_512;
        } else {
            throw new IllegalArgumentException("unknown algorithm identifier " + oid.getId());
        }
        return hashAlgo;
    }

    public static AlgorithmIdentifier extractDigesetAlgFromSigAlg(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier digestAlgOid;
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            ASN1Encodable asn1Encodable = sigAlgId.getParameters();
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)asn1Encodable);
            digestAlgOid = param.getHashAlgorithm().getAlgorithm();
        } else {
            HashAlgoType digestAlg;
            if (X9ObjectIdentifiers.ecdsa_with_SHA1.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA1;
            } else if (X9ObjectIdentifiers.ecdsa_with_SHA224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA224;
            } else if (X9ObjectIdentifiers.ecdsa_with_SHA256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA256;
            } else if (X9ObjectIdentifiers.ecdsa_with_SHA384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA384;
            } else if (X9ObjectIdentifiers.ecdsa_with_SHA512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA512;
            } else if (NISTObjectIdentifiers.id_ecdsa_with_sha3_224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_224;
            } else if (NISTObjectIdentifiers.id_ecdsa_with_sha3_256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_256;
            } else if (NISTObjectIdentifiers.id_ecdsa_with_sha3_384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_384;
            } else if (NISTObjectIdentifiers.id_ecdsa_with_sha3_512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_512;
            } else if (BSIObjectIdentifiers.ecdsa_plain_SHA1.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA1;
            } else if (BSIObjectIdentifiers.ecdsa_plain_SHA224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA224;
            } else if (BSIObjectIdentifiers.ecdsa_plain_SHA256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA256;
            } else if (BSIObjectIdentifiers.ecdsa_plain_SHA384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA384;
            } else if (BSIObjectIdentifiers.ecdsa_plain_SHA512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA512;
            } else if (X9ObjectIdentifiers.id_dsa_with_sha1.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA1;
            } else if (NISTObjectIdentifiers.dsa_with_sha224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA224;
            } else if (NISTObjectIdentifiers.dsa_with_sha256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA256;
            } else if (NISTObjectIdentifiers.dsa_with_sha384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA384;
            } else if (NISTObjectIdentifiers.dsa_with_sha512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA512;
            } else if (NISTObjectIdentifiers.id_dsa_with_sha3_224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_224;
            } else if (NISTObjectIdentifiers.id_dsa_with_sha3_256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_256;
            } else if (NISTObjectIdentifiers.id_dsa_with_sha3_384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_384;
            } else if (NISTObjectIdentifiers.id_dsa_with_sha3_512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_512;
            } else if (PKCSObjectIdentifiers.sha1WithRSAEncryption.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA1;
            } else if (PKCSObjectIdentifiers.sha224WithRSAEncryption.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA224;
            } else if (PKCSObjectIdentifiers.sha256WithRSAEncryption.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA256;
            } else if (PKCSObjectIdentifiers.sha384WithRSAEncryption.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA384;
            } else if (PKCSObjectIdentifiers.sha512WithRSAEncryption.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA512;
            } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_224;
            } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_256;
            } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_384;
            } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.equals((Object)algOid)) {
                digestAlg = HashAlgoType.SHA3_512;
            } else {
                throw new NoSuchAlgorithmException("unknown signature algorithm" + algOid.getId());
            }
            digestAlgOid = digestAlg.oid();
        }
        return new AlgorithmIdentifier(digestAlgOid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static boolean equalsAlgoName(String algoNameA, String algoNameB) {
        String tmpB;
        ParamUtil.requireNonBlank((String)"algoNameA", (String)algoNameA);
        ParamUtil.requireNonBlank((String)"algoNameB", (String)algoNameB);
        if (algoNameA.equalsIgnoreCase(algoNameB)) {
            return true;
        }
        String tmpA = algoNameA;
        if (tmpA.indexOf(45) != -1) {
            tmpA = tmpA.replace("-", "");
        }
        if ((tmpB = algoNameB).indexOf(45) != -1) {
            tmpB = tmpB.replace("-", "");
        }
        if (tmpA.equalsIgnoreCase(tmpB)) {
            return true;
        }
        return AlgorithmUtil.splitAlgoNameTokens(tmpA).equals(AlgorithmUtil.splitAlgoNameTokens(tmpB));
    }

    private static Set<String> splitAlgoNameTokens(String algoName) {
        ParamUtil.requireNonNull((String)"algoName", (Object)algoName);
        String tmpAlgoName = algoName.toUpperCase();
        int idx = tmpAlgoName.indexOf("AND");
        HashSet<String> set = new HashSet<String>();
        if (idx == -1) {
            set.add(tmpAlgoName);
            return set;
        }
        int len = tmpAlgoName.length();
        int beginIndex = 0;
        int endIndex = idx;
        while (true) {
            String token;
            if (StringUtil.isNotBlank((String)(token = tmpAlgoName.substring(beginIndex, endIndex)))) {
                set.add(token);
            }
            if (endIndex >= len) {
                return set;
            }
            beginIndex = endIndex + 3;
            if ((endIndex = tmpAlgoName.indexOf("AND", beginIndex)) != -1) continue;
            endIndex = len;
        }
    }

    public static AlgorithmIdentifier buildRSAPSSAlgId(HashAlgoType digestAlg) throws NoSuchAlgorithmException {
        RSASSAPSSparams params = AlgorithmUtil.createPSSRSAParams(digestAlg);
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)params);
    }

    public static AlgorithmIdentifier buildDSASigAlgId(HashAlgoType digestAlg) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier sid;
        ParamUtil.requireNonNull((String)"digestAlg", (Object)((Object)digestAlg));
        switch (digestAlg) {
            case SHA1: {
                sid = X9ObjectIdentifiers.id_dsa_with_sha1;
                break;
            }
            case SHA224: {
                sid = NISTObjectIdentifiers.dsa_with_sha224;
                break;
            }
            case SHA256: {
                sid = NISTObjectIdentifiers.dsa_with_sha256;
                break;
            }
            case SHA384: {
                sid = NISTObjectIdentifiers.dsa_with_sha384;
                break;
            }
            case SHA512: {
                sid = NISTObjectIdentifiers.dsa_with_sha512;
                break;
            }
            case SHA3_224: {
                sid = NISTObjectIdentifiers.id_dsa_with_sha3_224;
                break;
            }
            case SHA3_256: {
                sid = NISTObjectIdentifiers.id_dsa_with_sha3_256;
                break;
            }
            case SHA3_384: {
                sid = NISTObjectIdentifiers.id_dsa_with_sha3_384;
                break;
            }
            case SHA3_512: {
                sid = NISTObjectIdentifiers.id_dsa_with_sha3_512;
                break;
            }
            default: {
                throw new RuntimeException("unknown HashAlgoType: " + (Object)((Object)digestAlg));
            }
        }
        return new AlgorithmIdentifier(sid);
    }

    public static RSASSAPSSparams createPSSRSAParams(HashAlgoType digestAlg) throws NoSuchAlgorithmException {
        ParamUtil.requireNonNull((String)"digestAlg", (Object)((Object)digestAlg));
        int saltSize = digestAlg.length();
        AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(digestAlg.oid(), (ASN1Encodable)DERNull.INSTANCE);
        return new RSASSAPSSparams(digAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)digAlgId), new ASN1Integer((long)saltSize), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
    }

    public static ASN1ObjectIdentifier getCurveOidForName(String curveName) {
        ParamUtil.requireNonBlank((String)"curveName", (String)curveName);
        return curveNameOidMap.get(curveName.toLowerCase());
    }

    public static List<String> getECCurveNames() {
        return curveNames;
    }

    public static String getCurveName(ASN1ObjectIdentifier curveOid) {
        ParamUtil.requireNonNull((String)"curveOid", (Object)curveOid);
        String curveName = X962NamedCurves.getName((ASN1ObjectIdentifier)curveOid);
        if (curveName == null) {
            curveName = SECNamedCurves.getName((ASN1ObjectIdentifier)curveOid);
        }
        if (curveName == null) {
            curveName = TeleTrusTNamedCurves.getName((ASN1ObjectIdentifier)curveOid);
        }
        if (curveName == null) {
            curveName = NISTNamedCurves.getName((ASN1ObjectIdentifier)curveOid);
        }
        return curveName;
    }

    public static ASN1ObjectIdentifier getCurveOidForCurveNameOrOid(String curveNameOrOid) {
        ASN1ObjectIdentifier oid;
        ParamUtil.requireNonBlank((String)"curveNameOrOid", (String)curveNameOrOid);
        try {
            oid = new ASN1ObjectIdentifier(curveNameOrOid);
        }
        catch (Exception ex) {
            oid = AlgorithmUtil.getCurveOidForName(curveNameOrOid);
        }
        return oid;
    }

    static {
        LinkedList<String> nameList = new LinkedList<String>();
        HashMap<String, ASN1ObjectIdentifier> nameOidMap = new HashMap<String, ASN1ObjectIdentifier>();
        Enumeration names = org.bouncycastle.jce.ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ASN1ObjectIdentifier oid = ECNamedCurveTable.getOID((String)name);
            if (oid == null) continue;
            nameList.add(name);
            nameOidMap.put(name.toLowerCase(), oid);
        }
        Collections.sort(nameList);
        curveNames = Collections.unmodifiableList(nameList);
        curveNameOidMap = Collections.unmodifiableMap(nameOidMap);
        HashMap<String, AlgorithmCode> map = new HashMap<String, AlgorithmCode>();
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), AlgorithmCode.HMAC_SHA1);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), AlgorithmCode.HMAC_SHA224);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), AlgorithmCode.HMAC_SHA256);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), AlgorithmCode.HMAC_SHA384);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), AlgorithmCode.HMAC_SHA512);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_224.getId(), AlgorithmCode.HMAC_SHA224);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_256.getId(), AlgorithmCode.HMAC_SHA256);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_384.getId(), AlgorithmCode.HMAC_SHA384);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_512.getId(), AlgorithmCode.HMAC_SHA512);
        map.put(NISTObjectIdentifiers.id_aes128_GCM.getId(), AlgorithmCode.AES128_GMAC);
        map.put(NISTObjectIdentifiers.id_aes192_GCM.getId(), AlgorithmCode.AES192_GMAC);
        map.put(NISTObjectIdentifiers.id_aes256_GCM.getId(), AlgorithmCode.AES256_GMAC);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA1.getId(), AlgorithmCode.SHA1WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA224.getId(), AlgorithmCode.SHA224WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA256.getId(), AlgorithmCode.SHA256WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA384.getId(), AlgorithmCode.SHA384WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA512.getId(), AlgorithmCode.SHA512WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224.getId(), AlgorithmCode.SHA3_224WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256.getId(), AlgorithmCode.SHA3_256WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384.getId(), AlgorithmCode.SHA3_384WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512.getId(), AlgorithmCode.SHA3_512WITHECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA1.getId(), AlgorithmCode.SHA1WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA224.getId(), AlgorithmCode.SHA224WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA256.getId(), AlgorithmCode.SHA256WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA384.getId(), AlgorithmCode.SHA384WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA512.getId(), AlgorithmCode.SHA512WITHPLAIN_ECDSA);
        map.put(X9ObjectIdentifiers.id_dsa_with_sha1.getId(), AlgorithmCode.SHA1WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha224.getId(), AlgorithmCode.SHA224WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha256.getId(), AlgorithmCode.SHA256WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha384.getId(), AlgorithmCode.SHA384WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha512.getId(), AlgorithmCode.SHA512WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_224.getId(), AlgorithmCode.SHA3_224WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_256.getId(), AlgorithmCode.SHA3_256WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_384.getId(), AlgorithmCode.SHA3_384WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_512.getId(), AlgorithmCode.SHA3_512WITHDSA);
        map.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), AlgorithmCode.SHA1WITHDSA);
        map.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), AlgorithmCode.SHA224WITHRSA);
        map.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), AlgorithmCode.SHA256WITHRSA);
        map.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), AlgorithmCode.SHA384WITHRSA);
        map.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), AlgorithmCode.SHA512WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.getId(), AlgorithmCode.SHA3_224WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.getId(), AlgorithmCode.SHA3_256WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.getId(), AlgorithmCode.SHA3_384WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.getId(), AlgorithmCode.SHA3_512WITHRSA);
        for (HashAlgoType hashAlgo : HashAlgoType.values()) {
            map.put(hashAlgo.oid().getId(), hashAlgo.algorithmCode());
        }
        algNameCodeMap = Collections.unmodifiableMap(map);
    }
}

