/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit;

import android.os.Handler;
import android.os.Looper;
import com.github.pengfeizhou.jscore.JSDecoder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pub.doric.DoricRegistry;
import pub.doric.IDoricDriver;
import pub.doric.async.AsyncCall;
import pub.doric.async.AsyncResult;
import pub.doric.devkit.DoricDebugJSEngine;
import pub.doric.devkit.DoricDev;
import pub.doric.devkit.WSClient;
import pub.doric.utils.DoricLog;
import pub.doric.utils.ThreadMode;

public class DoricDebugDriver
implements IDoricDriver {
    private final DoricDebugJSEngine doricDebugJSEngine;
    private final ExecutorService mBridgeExecutor;
    private final Handler mUIHandler;
    private String theContextId = null;

    public DoricDebugDriver(WSClient wsClient) {
        this.doricDebugJSEngine = new DoricDebugJSEngine(wsClient);
        this.mBridgeExecutor = Executors.newCachedThreadPool();
        this.mUIHandler = new Handler(Looper.getMainLooper());
    }

    public AsyncResult<JSDecoder> invokeContextEntityMethod(String contextId, String method, Object ... args) {
        Object[] nArgs = new Object[args.length + 2];
        nArgs[0] = contextId;
        nArgs[1] = method;
        if (args.length > 0) {
            System.arraycopy(args, 0, nArgs, 2, args.length);
        }
        return this.invokeDoricMethod("jsCallEntityMethod", nArgs);
    }

    public AsyncResult<JSDecoder> invokeDoricMethod(final String method, final Object ... args) {
        return this.asyncCall(new Callable<JSDecoder>(){

            @Override
            public JSDecoder call() {
                try {
                    return DoricDebugDriver.this.doricDebugJSEngine.invokeDoricMethod(method, args);
                }
                catch (Exception e) {
                    DoricLog.e((String)"invokeDoricMethod(%s,...),error is %s", (Object[])new Object[]{method, e.getLocalizedMessage()});
                    return new JSDecoder(null);
                }
            }
        }, ThreadMode.JS);
    }

    public <T> AsyncResult<T> asyncCall(Callable<T> callable, ThreadMode threadMode) {
        switch (threadMode) {
            case UI: {
                return AsyncCall.ensureRunInHandler((Handler)this.mUIHandler, callable);
            }
            case JS: {
                if (this.doricDebugJSEngine.isInvokingMethod()) break;
                return AsyncCall.ensureRunInHandler((Handler)this.doricDebugJSEngine.getJSHandler(), callable);
            }
        }
        return AsyncCall.ensureRunInExecutor((ExecutorService)this.mBridgeExecutor, callable);
    }

    public AsyncResult<Boolean> createContext(final String contextId, String script, final String source) {
        return this.asyncCall(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    DoricDebugDriver.this.theContextId = contextId;
                    return true;
                }
                catch (Exception e) {
                    DoricLog.e((String)"createContext %s error is %s", (Object[])new Object[]{source, e.getLocalizedMessage()});
                    return false;
                }
            }
        }, ThreadMode.JS);
    }

    public AsyncResult<Boolean> destroyContext(final String contextId) {
        return this.asyncCall(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    if (contextId.equals(DoricDebugDriver.this.theContextId)) {
                        DoricDev.getInstance().stopDebugging(false);
                    }
                    return true;
                }
                catch (Exception e) {
                    DoricLog.e((String)"destroyContext %s error is %s", (Object[])new Object[]{contextId, e.getLocalizedMessage()});
                    return false;
                }
            }
        }, ThreadMode.JS);
    }

    public DoricRegistry getRegistry() {
        return this.doricDebugJSEngine.getRegistry();
    }

    public void destroy() {
        this.doricDebugJSEngine.teardown();
        this.mBridgeExecutor.shutdown();
    }
}

