/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit;

import com.github.pengfeizhou.jscore.JSONBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import pub.doric.DoricContext;
import pub.doric.IDoricMonitor;
import pub.doric.devkit.DoricDev;
import pub.doric.utils.DoricLog;

public class DoricDevMonitor
implements IDoricMonitor {
    public void onException(DoricContext context, Exception e) {
        if (!DoricDev.getInstance().isInDevMode()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        DoricDev.getInstance().sendDevCommand("EXCEPTION", new JSONBuilder().put("source", (Object)("In source file: " + (context != null ? context.getSource() : "Unknown"))).put("exception", (Object)stringWriter.toString()).toJSONObject());
    }

    public void onLog(int type, String message) {
        if (!DoricDev.getInstance().isInDevMode()) {
            return;
        }
        String typeString = "DEFAULT";
        switch (type) {
            case 6: {
                DoricLog.suffix_e((String)"_js", (String)message, (Object[])new Object[0]);
                typeString = "ERROR";
                break;
            }
            case 5: {
                DoricLog.suffix_w((String)"_js", (String)message, (Object[])new Object[0]);
                typeString = "WARN";
                break;
            }
            default: {
                DoricLog.suffix_d((String)"_js", (String)message, (Object[])new Object[0]);
            }
        }
        DoricDev.getInstance().sendDevCommand("LOG", new JSONBuilder().put("type", (Object)typeString).put("message", (Object)message).toJSONObject());
    }
}

