/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit;

import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pub.doric.performance.DoricPerformanceProfile;

public class DoricDevPerformanceAnchorHook
implements DoricPerformanceProfile.GlobalAnchorHook {
    private static final String TAG = "DoricPerformance";
    private final Map<String, List<AnchorNode>> nodeMap = new HashMap<String, List<AnchorNode>>();
    private final Comparator<AnchorNode> comparator = new Comparator<AnchorNode>(){

        @Override
        public int compare(AnchorNode o1, AnchorNode o2) {
            return (int)(o1.prepare - o2.prepare);
        }
    };

    public void onAnchor(DoricPerformanceProfile profile, String name, long prepare, long start, long end) {
        Log.d((String)TAG, (String)String.format("%s: %s prepared %dms, cost %dms.", profile.getName(), name, start - prepare, end - start));
        List<AnchorNode> list = this.nodeMap.get(profile.getName());
        if (list == null) {
            list = new ArrayList<AnchorNode>();
            this.nodeMap.put(profile.getName(), list);
        }
        list.add(new AnchorNode(name, prepare, start, end));
        Collections.sort(list, this.comparator);
        if (name.equals("Destroy")) {
            this.nodeMap.remove(profile.getName());
        }
    }

    public void onAnchor(String name, long prepare, long start, long end) {
    }

    public List<AnchorNode> getAnchorNodeList(String name) {
        List<AnchorNode> ret = this.nodeMap.get(name);
        if (ret == null) {
            ret = new ArrayList<AnchorNode>();
        }
        return ret;
    }

    public static class AnchorNode {
        public String name;
        public long prepare;
        public long start;
        public long end;

        AnchorNode(String name, long prepare, long start, long end) {
            this.name = name;
            this.prepare = prepare;
            this.start = start;
            this.end = end;
        }
    }
}

