/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.qrcode.activity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import pub.doric.devkit.R;
import pub.doric.devkit.qrcode.activity.CaptureFragment;
import pub.doric.devkit.qrcode.activity.CodeUtils;

public class CaptureActivity
extends AppCompatActivity {
    CodeUtils.AnalyzeCallback analyzeCallback = new CodeUtils.AnalyzeCallback(){

        @Override
        public void onAnalyzeSuccess(Bitmap mBitmap, String result) {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putInt("result_type", 1);
            bundle.putString("result_string", result);
            resultIntent.putExtras(bundle);
            CaptureActivity.this.setResult(-1, resultIntent);
            CaptureActivity.this.finish();
        }

        @Override
        public void onAnalyzeFailed() {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putInt("result_type", 2);
            bundle.putString("result_string", "");
            resultIntent.putExtras(bundle);
            CaptureActivity.this.setResult(-1, resultIntent);
            CaptureActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera);
        CaptureFragment captureFragment = new CaptureFragment();
        captureFragment.setAnalyzeCallback(this.analyzeCallback);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fl_zxing_container, (Fragment)captureFragment).commit();
        captureFragment.setCameraInitCallBack(new CaptureFragment.CameraInitCallBack(){

            @Override
            public void callBack(Exception e) {
                if (e != null) {
                    Log.e((String)"TAG", (String)"callBack: ", (Throwable)e);
                }
            }
        });
    }
}

