/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.qrcode.activity;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import java.util.Vector;
import pub.doric.devkit.R;
import pub.doric.devkit.qrcode.activity.CodeUtils;
import pub.doric.devkit.qrcode.camera.CameraManager;
import pub.doric.devkit.qrcode.decoding.CaptureActivityHandler;
import pub.doric.devkit.qrcode.decoding.InactivityTimer;
import pub.doric.devkit.qrcode.view.ViewfinderView;

public class CaptureFragment
extends Fragment
implements SurfaceHolder.Callback {
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private static final float BEEP_VOLUME = 0.1f;
    private boolean vibrate = false;
    private SurfaceView surfaceView;
    private SurfaceHolder surfaceHolder;
    private CodeUtils.AnalyzeCallback analyzeCallback;
    private Camera camera;
    private static final long VIBRATE_DURATION = 200L;
    @Nullable
    CameraInitCallBack callBack;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CameraManager.init((Context)this.getActivity().getApplication());
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer((Activity)this.getActivity());
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        int layoutId;
        Bundle bundle = this.getArguments();
        View view = null;
        if (bundle != null && (layoutId = bundle.getInt("layout_id")) != -1) {
            view = inflater.inflate(layoutId, null);
        }
        if (view == null) {
            view = inflater.inflate(R.layout.fragment_capture, null);
        }
        this.viewfinderView = (ViewfinderView)view.findViewById(R.id.viewfinder_view);
        this.surfaceView = (SurfaceView)view.findViewById(R.id.preview_view);
        this.surfaceHolder = this.surfaceView.getHolder();
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.hasSurface) {
            this.initCamera(this.surfaceHolder);
        } else {
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.surfaceHolder.setType(3);
        }
        this.decodeFormats = null;
        this.characterSet = null;
    }

    public void onPause() {
        super.onPause();
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        CameraManager.get().closeDriver();
    }

    public void onDestroy() {
        super.onDestroy();
        this.inactivityTimer.shutdown();
    }

    public void handleDecode(Result result, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        this.playVibrate();
        if (result == null || TextUtils.isEmpty((CharSequence)result.getText())) {
            if (this.analyzeCallback != null) {
                this.analyzeCallback.onAnalyzeFailed();
            }
        } else if (this.analyzeCallback != null) {
            this.analyzeCallback.onAnalyzeSuccess(barcode, result.getText());
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
            this.camera = CameraManager.get().getCamera();
        }
        catch (Exception e) {
            if (this.callBack != null) {
                this.callBack.callBack(e);
            }
            return;
        }
        if (this.callBack != null) {
            this.callBack.callBack(null);
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet, this.viewfinderView);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
        if (this.camera != null && this.camera != null && CameraManager.get().isPreviewing()) {
            if (!CameraManager.get().isUseOneShotPreviewCallback()) {
                this.camera.setPreviewCallback(null);
            }
            this.camera.stopPreview();
            CameraManager.get().getPreviewCallback().setHandler(null, 0);
            CameraManager.get().getAutoFocusCallback().setHandler(null, 0);
            CameraManager.get().setPreviewing(false);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    private void playVibrate() {
        if (this.vibrate) {
            FragmentActivity fragmentActivity = this.getActivity();
            this.getActivity();
            Vibrator vibrator = (Vibrator)fragmentActivity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    public CodeUtils.AnalyzeCallback getAnalyzeCallback() {
        return this.analyzeCallback;
    }

    public void setAnalyzeCallback(CodeUtils.AnalyzeCallback analyzeCallback) {
        this.analyzeCallback = analyzeCallback;
    }

    public void setCameraInitCallBack(CameraInitCallBack callBack) {
        this.callBack = callBack;
    }

    static interface CameraInitCallBack {
        public void callBack(Exception var1);
    }
}

