/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.remote;

import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JavaFunction;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pub.doric.devkit.WSClient;
import pub.doric.devkit.remote.ValueBuilder;

public class RemoteJSExecutor
implements WSClient.Interceptor {
    private final Map<String, JavaFunction> globalFunctions = new HashMap<String, JavaFunction>();
    private final WSClient wsClient;
    private final Thread currentThread;
    private final AtomicInteger callIdCounter = new AtomicInteger();
    private Map<Integer, Thread> mThreads = new HashMap<Integer, Thread>();
    private Map<Integer, JSDecoder> mResults = new HashMap<Integer, JSDecoder>();
    public volatile boolean invokingMethod = false;

    public RemoteJSExecutor(WSClient wsClient) {
        this.wsClient = wsClient;
        this.wsClient.addInterceptor(this);
        this.currentThread = Thread.currentThread();
    }

    public String loadJS(String script, String source) {
        return null;
    }

    public JSDecoder evaluateJS(String script, String source, boolean hashKey) {
        return null;
    }

    public void injectGlobalJSFunction(String name, JavaFunction javaFunction) {
        this.globalFunctions.put(name, javaFunction);
        this.wsClient.sendToDebugger("injectGlobalJSFunction", new JSONBuilder().put("cmd", (Object)"injectGlobalJSFunction").put("name", (Object)name).toJSONObject());
    }

    public void injectGlobalJSObject(String name, JavaValue javaValue) {
        this.wsClient.sendToDebugger("injectGlobalJSObject", new JSONBuilder().put("name", (Object)name).put("type", (Object)javaValue.getType()).put("value", (Object)javaValue.getValue()).toJSONObject());
    }

    public JSDecoder invokeMethod(String objectName, String functionName, JavaValue[] javaValues, boolean hashKey) {
        JSONArray jsonArray = new JSONArray();
        for (JavaValue javaValue : javaValues) {
            jsonArray.put((Object)new JSONBuilder().put("type", (Object)javaValue.getType()).put("value", (Object)javaValue.getValue()).toJSONObject());
        }
        int callId = this.callIdCounter.incrementAndGet();
        this.wsClient.sendToDebugger("invokeMethod", new JSONBuilder().put("cmd", (Object)"invokeMethod").put("objectName", (Object)objectName).put("functionName", (Object)functionName).put("values", (Object)jsonArray).put("callId", (Object)callId).put("hashKey", (Object)hashKey).toJSONObject());
        this.invokingMethod = true;
        Thread thread = Thread.currentThread();
        this.mThreads.put(callId, thread);
        LockSupport.park(thread);
        this.invokingMethod = false;
        return this.mResults.remove(callId);
    }

    public void destroy() {
        this.wsClient.sendToDebugger("DEBUG_STOP", null);
        this.wsClient.removeInterceptor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intercept(String type, String cmd, JSONObject payload) throws JSONException {
        if ("D2C".equals(type)) {
            switch (cmd) {
                case "injectGlobalJSFunction": {
                    String name = payload.optString("name");
                    JSONArray arguments = payload.optJSONArray("arguments");
                    assert (arguments != null);
                    JSDecoder[] decoders = new JSDecoder[arguments.length()];
                    for (int i = 0; i < arguments.length(); ++i) {
                        Object o = arguments.get(i);
                        decoders[i] = new JSDecoder(new ValueBuilder(o).build());
                    }
                    this.globalFunctions.get(name).exec(decoders);
                    break;
                }
                case "invokeMethod": {
                    int callId = payload.optInt("callId");
                    try {
                        Object result = payload.opt("result");
                        ValueBuilder vb = new ValueBuilder(result);
                        this.mResults.put(callId, new JSDecoder(vb.build()));
                        System.out.println(result);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break;
                    }
                    finally {
                        LockSupport.unpark(this.mThreads.remove(callId));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

