/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.remote;

import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ValueBuilder {
    private final Object val;

    private void writeBoolean(ByteArrayOutputStream output, boolean b) {
        output.write((byte)(b ? 1 : 0));
    }

    private void writeInt(ByteArrayOutputStream output, int i) {
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    private void writeDouble(ByteArrayOutputStream output, double d) {
        long l = Double.doubleToRawLongBits(d);
        output.write((byte)(l >>> 56));
        output.write((byte)(l >>> 48));
        output.write((byte)(l >>> 40));
        output.write((byte)(l >>> 32));
        output.write((byte)(l >>> 24));
        output.write((byte)(l >>> 16));
        output.write((byte)(l >>> 8));
        output.write((byte)l);
    }

    private void writeString(ByteArrayOutputStream output, String S) {
        byte[] buf;
        try {
            buf = S.getBytes("UTF-8");
        }
        catch (Exception e) {
            buf = new byte[]{};
        }
        int i = buf.length;
        this.writeInt(output, i);
        output.write(buf, 0, i);
    }

    private void write(ByteArrayOutputStream output, Object O) {
        if (O instanceof Number) {
            output.write(68);
            this.writeDouble(output, Double.valueOf(String.valueOf(O)));
        } else if (O instanceof String) {
            output.write(83);
            this.writeString(output, (String)O);
        } else if (O instanceof Boolean) {
            output.write(66);
            this.writeBoolean(output, (Boolean)O);
        } else if (O instanceof JSONObject) {
            output.write(79);
            Iterator iterator = ((JSONObject)O).keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.write(output, key);
                this.write(output, ((JSONObject)O).opt(key));
            }
            output.write(78);
        } else if (O instanceof JSONArray) {
            output.write(65);
            this.writeInt(output, ((JSONArray)O).length());
            for (int i = 0; i < ((JSONArray)O).length(); ++i) {
                this.write(output, ((JSONArray)O).opt(i));
            }
        } else {
            output.write(78);
        }
    }

    public ValueBuilder(Object o) {
        this.val = o;
    }

    public byte[] build() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.write(outputStream, this.val);
        return outputStream.toByteArray();
    }
}

