/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.connection;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.LoadException;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.classloader.ClassLoaderFactory;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.GeronimoConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JBossConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JDMKConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JSR160ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.Mx4jConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.Oc4jConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.PramatiConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.SJSASConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.Tomcat55ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.Weblogic9ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.Weblogic9Jsr77ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.WeblogicConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.WebsphereConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.WebsphereStudioConnectionTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory {
    private static final String BROAD_SEARCH_PROPERTY = "mc4j.ems.fileSearchBroad";
    private static final int DEFAULT_SEARCH_DEPTH = 6;
    private static final String SEARCH_DEPTH_PROPERTY = "mc4j.ems.fileSearchDepth";
    public static final String COPY_JARS_TO_TEMP = "mc4j.ems.CopyJarsToTemp";
    public static final String JAR_TEMP_DIR = "mc4j.ems.JarTempDir";
    public static final String USE_CONTEXT_CLASSLOADER = "mc4j.ems.UseContextClassLoader";
    private boolean broadSearch = false;
    private int searchDepth = 6;
    private static Log log = LogFactory.getLog(ConnectionFactory.class);
    public static final ConnectionTypeDescriptor[] CONNECTION_DESCRIPTORS = new ConnectionTypeDescriptor[]{new InternalVMTypeDescriptor(), new LocalVMTypeDescriptor(), new JBossConnectionTypeDescriptor(), new Tomcat55ConnectionTypeDescriptor(), new JDMKConnectionTypeDescriptor(), new J2SE5ConnectionTypeDescriptor(), new JSR160ConnectionTypeDescriptor(), new GeronimoConnectionTypeDescriptor(), new Mx4jConnectionTypeDescriptor(), new Oc4jConnectionTypeDescriptor(), new PramatiConnectionTypeDescriptor(), new SJSASConnectionTypeDescriptor(), new WeblogicConnectionTypeDescriptor(), new Weblogic9ConnectionTypeDescriptor(), new Weblogic9Jsr77ConnectionTypeDescriptor(), new WebsphereConnectionTypeDescriptor(), new WebsphereStudioConnectionTypeDescriptor()};

    public static List<ConnectionTypeDescriptor> getConnectionTypes() {
        return Arrays.asList(CONNECTION_DESCRIPTORS);
    }

    public ConnectionFactory() {
        if (System.getProperty(BROAD_SEARCH_PROPERTY) != null) {
            this.broadSearch = Boolean.valueOf(System.getProperty(BROAD_SEARCH_PROPERTY));
        }
        if (System.getProperty(SEARCH_DEPTH_PROPERTY) != null) {
            this.searchDepth = Integer.parseInt(System.getProperty(SEARCH_DEPTH_PROPERTY));
        }
    }

    public ConnectionProvider getConnectionProvider(ConnectionSettings connectionSettings) {
        String className = connectionSettings.getConnectionType().getConnectionNodeClassName();
        try {
            ClassLoader loader = ClassLoaderFactory.getInstance().buildClassLoader(connectionSettings);
            log.debug((Object)("Loading connection class from ClassLoader [" + loader + "] ConnectionProvider class [" + className + "]"));
            Class<?> clazz = Class.forName(className, false, loader);
            ConnectionProvider connectionProvider = (ConnectionProvider)clazz.newInstance();
            connectionProvider.initialize(connectionSettings);
            return connectionProvider;
        }
        catch (IllegalAccessException e) {
            throw new ConnectionException("Could not access ConnectionClass", e);
        }
        catch (InstantiationException e) {
            throw new ConnectionException("Could not instantiate ConnectionClass", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionException("Could not find ConnectionClass " + className, e);
        }
    }

    public EmsConnection connect(ConnectionSettings connectionSettings) {
        log.info((Object)("Connecting to " + connectionSettings.toString()));
        return this.getConnectionProvider(connectionSettings).connect();
    }

    public void discoverServerClasses(ConnectionSettings connectionSettings) {
        if (connectionSettings.getLibraryURI() != null) {
            long start = System.currentTimeMillis();
            String[] serverFiles = connectionSettings.getConnectionType().getConnectionClasspathEntries();
            if (serverFiles == null) {
                return;
            }
            File serverInstall = new File(connectionSettings.getLibraryURI());
            if (!serverInstall.exists()) {
                throw new LoadException("Supplied server installation does not exist " + connectionSettings.getLibraryURI());
            }
            ArrayList<File> foundFiles = new ArrayList<File>();
            for (String serverFile : serverFiles) {
                if (this.broadSearch && serverFile.indexOf(47) >= 0) {
                    serverFile = serverFile.substring(serverFile.lastIndexOf(47) + 1);
                }
                log.debug((Object)("Searching for library " + serverFile));
                File[] matchedFiles = null;
                try {
                    if (serverFile.indexOf(47) >= 0) {
                        matchedFiles = this.findDeepFiles(serverInstall, serverFile);
                    } else {
                        File file = this.findFile(serverInstall, serverFile);
                        if (file != null) {
                            matchedFiles = new File[]{file};
                        }
                    }
                }
                catch (Exception e) {
                    log.info((Object)("Library dependency not found " + serverFile), (Throwable)e);
                }
                if (matchedFiles != null) {
                    for (File matchedFile : matchedFiles) {
                        if (matchedFile == null || foundFiles.contains(matchedFile)) continue;
                        foundFiles.add(matchedFile);
                        log.debug((Object)("Library dependency resolved " + matchedFile.getAbsolutePath()));
                    }
                    continue;
                }
                log.info((Object)("Connection library dependancy [" + serverFile + "] not found  in directory: " + serverInstall));
            }
            if (connectionSettings.getClassPathEntries() == null) {
                connectionSettings.setClassPathEntries(foundFiles);
            } else {
                connectionSettings.getClassPathEntries().addAll(foundFiles);
            }
            log.info((Object)("Discovered libraries in " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    private File findFile(File directory, String filename) {
        return this.findFile(directory, filename, 1);
    }

    private File findFile(File directory, String filename, int depth) {
        if (depth > this.searchDepth) {
            return null;
        }
        File[] children = directory.listFiles();
        if (children == null) {
            return null;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                File result = this.findFile(child, filename, depth + 1);
                if (result == null) continue;
                return result;
            }
            if (!filename.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        return null;
    }

    private File[] findDeepFiles(File directory, String filename) {
        int in;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        if ((in = filename.indexOf("/")) < 0) {
            if (filename.equals("*")) {
                return directory.listFiles();
            }
            File match = this.getChild(directory, filename);
            if (match == null) {
                return null;
            }
            return new File[]{match};
        }
        String dir = filename.substring(0, in);
        String restOfName = filename.substring(in + 1, filename.length());
        if (dir.equals("*")) {
            File[] children = directory.listFiles(new DirectoryFilter());
            if (children != null) {
                for (File child : children) {
                    File[] childDir = this.findDeepFiles(child, restOfName);
                    if (childDir == null) continue;
                    return childDir;
                }
            }
            log.debug((Object)("Could not find " + directory.getAbsolutePath() + " :: " + restOfName));
            return null;
        }
        File childDir = this.getChild(directory, dir);
        if (childDir == null) {
            log.debug((Object)("Could not find " + directory.getAbsolutePath() + " :: " + restOfName));
            return null;
        }
        return this.findDeepFiles(childDir, restOfName);
    }

    public File getChild(File directory, final String childName) {
        if (directory == null) {
            return null;
        }
        if (!directory.exists()) {
            return null;
        }
        File[] children = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return childName.equals(name);
            }
        });
        if (children.length == 1) {
            return children[0];
        }
        return null;
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

