/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class VertxRouter {
    @Inject
    @ConfigProperty(name="kogito.dataindex.http.url", defaultValue="http://localhost:8180")
    String dataIndexHttpURL;
    @Inject
    @ConfigProperty(name="kogito.dataindex.ws.url", defaultValue="ws://localhost:8180")
    String dataIndexWsURL;
    @Inject
    Vertx vertx;
    private Buffer resource;

    @PostConstruct
    public void init() {
        try {
            this.resource = Buffer.buffer((String)this.vertx.fileSystem().readFileBlocking("META-INF/resources/index.html").toString(StandardCharsets.UTF_8).replace("__GRAPHQL_HTTP_ENDPOINT__", "\"" + this.dataIndexHttpURL + "/graphql\"").replace("__GRAPHQL_WS_ENDPOINT__", "\"" + this.dataIndexWsURL + "/graphql\""));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setupRouter(@Observes Router router) {
        router.route().handler((Handler)LoggerHandler.create());
        router.route().handler((Handler)FaviconHandler.create());
        router.route().handler((Handler)StaticHandler.create());
        router.route(HttpMethod.GET, "/").handler(ctx -> ctx.response().end(this.resource));
    }
}

