/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.ConfigurationEndpoint;
import org.wildfly.swarm.config.remoting.subsystem.connector.Connector;
import org.wildfly.swarm.config.remoting.subsystem.httpConnector.HttpConnector;
import org.wildfly.swarm.config.remoting.subsystem.localOutboundConnection.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.subsystem.outboundConnection.OutboundConnection;
import org.wildfly.swarm.config.remoting.subsystem.remoteOutboundConnection.RemoteOutboundConnection;

@Address(value="/subsystem=remoting")
@Implicit
public class Remoting<T extends Remoting> {
    private String key = "remoting";
    private RemotingResources subresources = new RemotingResources();
    private ConfigurationEndpoint configurationEndpoint;

    public String getKey() {
        return this.key;
    }

    public RemotingResources subresources() {
        return this.subresources;
    }

    public T httpConnectors(List<HttpConnector> value) {
        this.subresources.httpConnectors.addAll(value);
        return (T)this;
    }

    public T httpConnector(HttpConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors.addAll(value);
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T outboundConnections(List<OutboundConnection> value) {
        this.subresources.outboundConnections.addAll(value);
        return (T)this;
    }

    public T outboundConnection(OutboundConnection value) {
        this.subresources.outboundConnections.add(value);
        return (T)this;
    }

    public T localOutboundConnections(List<LocalOutboundConnection> value) {
        this.subresources.localOutboundConnections.addAll(value);
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnection value) {
        this.subresources.localOutboundConnections.add(value);
        return (T)this;
    }

    public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
        this.subresources.remoteOutboundConnections.addAll(value);
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnection value) {
        this.subresources.remoteOutboundConnections.add(value);
        return (T)this;
    }

    @Subresource
    public ConfigurationEndpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public T configurationEndpoint(ConfigurationEndpoint value) {
        this.configurationEndpoint = value;
        return (T)this;
    }

    public class RemotingResources {
        private List<HttpConnector> httpConnectors = new ArrayList<HttpConnector>();
        private List<Connector> connectors = new ArrayList<Connector>();
        private List<OutboundConnection> outboundConnections = new ArrayList<OutboundConnection>();
        private List<LocalOutboundConnection> localOutboundConnections = new ArrayList<LocalOutboundConnection>();
        private List<RemoteOutboundConnection> remoteOutboundConnections = new ArrayList<RemoteOutboundConnection>();

        @Subresource
        public List<HttpConnector> httpConnectors() {
            return this.httpConnectors;
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        @Subresource
        public List<OutboundConnection> outboundConnections() {
            return this.outboundConnections;
        }

        @Subresource
        public List<LocalOutboundConnection> localOutboundConnections() {
            return this.localOutboundConnections;
        }

        @Subresource
        public List<RemoteOutboundConnection> remoteOutboundConnections() {
            return this.remoteOutboundConnections;
        }
    }
}

