/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.ConfigurationFilter;
import org.wildfly.swarm.config.undertow.subsystem.ConfigurationHandler;
import org.wildfly.swarm.config.undertow.subsystem.bufferCache.BufferCache;
import org.wildfly.swarm.config.undertow.subsystem.server.Server;
import org.wildfly.swarm.config.undertow.subsystem.servletContainer.ServletContainer;

@Address(value="/subsystem=undertow")
@Implicit
public class Undertow<T extends Undertow> {
    private String key = "undertow";
    private String defaultServer;
    private String defaultServletContainer;
    private String defaultVirtualHost;
    private String instanceId;
    private Boolean statisticsEnabled;
    private UndertowResources subresources = new UndertowResources();
    private ConfigurationHandler configurationHandler;
    private ConfigurationFilter configurationFilter;

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="default-server")
    public String defaultServer() {
        return this.defaultServer;
    }

    public T defaultServer(String value) {
        this.defaultServer = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-servlet-container")
    public String defaultServletContainer() {
        return this.defaultServletContainer;
    }

    public T defaultServletContainer(String value) {
        this.defaultServletContainer = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-virtual-host")
    public String defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public T defaultVirtualHost(String value) {
        this.defaultVirtualHost = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="instance-id")
    public String instanceId() {
        return this.instanceId;
    }

    public T instanceId(String value) {
        this.instanceId = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        this.statisticsEnabled = value;
        return (T)this;
    }

    public UndertowResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers.addAll(value);
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T bufferCaches(List<BufferCache> value) {
        this.subresources.bufferCaches.addAll(value);
        return (T)this;
    }

    public T bufferCache(BufferCache value) {
        this.subresources.bufferCaches.add(value);
        return (T)this;
    }

    public T servletContainers(List<ServletContainer> value) {
        this.subresources.servletContainers.addAll(value);
        return (T)this;
    }

    public T servletContainer(ServletContainer value) {
        this.subresources.servletContainers.add(value);
        return (T)this;
    }

    @Subresource
    public ConfigurationHandler configurationHandler() {
        return this.configurationHandler;
    }

    public T configurationHandler(ConfigurationHandler value) {
        this.configurationHandler = value;
        return (T)this;
    }

    @Subresource
    public ConfigurationFilter configurationFilter() {
        return this.configurationFilter;
    }

    public T configurationFilter(ConfigurationFilter value) {
        this.configurationFilter = value;
        return (T)this;
    }

    public class UndertowResources {
        private List<Server> servers = new ArrayList<Server>();
        private List<BufferCache> bufferCaches = new ArrayList<BufferCache>();
        private List<ServletContainer> servletContainers = new ArrayList<ServletContainer>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        @Subresource
        public List<BufferCache> bufferCaches() {
            return this.bufferCaches;
        }

        @Subresource
        public List<ServletContainer> servletContainers() {
            return this.servletContainers;
        }
    }
}

