/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.HttpConnector;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;

@ResourceType(value="subsystem")
@Implicit
public class Remoting<T extends Remoting> {
    private String key = "remoting";
    private RemotingResources subresources = new RemotingResources();
    private EndpointConfiguration endpointConfiguration;

    public String getKey() {
        return this.key;
    }

    public RemotingResources subresources() {
        return this.subresources;
    }

    public T httpConnectors(List<HttpConnector> value) {
        this.subresources.httpConnectors.addAll(value);
        return (T)this;
    }

    public T httpConnector(HttpConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors.addAll(value);
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T outboundConnections(List<OutboundConnection> value) {
        this.subresources.outboundConnections.addAll(value);
        return (T)this;
    }

    public T outboundConnection(OutboundConnection value) {
        this.subresources.outboundConnections.add(value);
        return (T)this;
    }

    public T localOutboundConnections(List<LocalOutboundConnection> value) {
        this.subresources.localOutboundConnections.addAll(value);
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnection value) {
        this.subresources.localOutboundConnections.add(value);
        return (T)this;
    }

    public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
        this.subresources.remoteOutboundConnections.addAll(value);
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnection value) {
        this.subresources.remoteOutboundConnections.add(value);
        return (T)this;
    }

    @Subresource
    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public T endpointConfiguration(EndpointConfiguration value) {
        this.endpointConfiguration = value;
        return (T)this;
    }

    public class RemotingResources {
        private List<HttpConnector> httpConnectors = new ArrayList<HttpConnector>();
        private List<Connector> connectors = new ArrayList<Connector>();
        private List<OutboundConnection> outboundConnections = new ArrayList<OutboundConnection>();
        private List<LocalOutboundConnection> localOutboundConnections = new ArrayList<LocalOutboundConnection>();
        private List<RemoteOutboundConnection> remoteOutboundConnections = new ArrayList<RemoteOutboundConnection>();

        @Subresource
        public List<HttpConnector> httpConnectors() {
            return this.httpConnectors;
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        @Subresource
        public List<OutboundConnection> outboundConnections() {
            return this.outboundConnections;
        }

        @Subresource
        public List<LocalOutboundConnection> localOutboundConnections() {
            return this.localOutboundConnections;
        }

        @Subresource
        public List<RemoteOutboundConnection> remoteOutboundConnections() {
            return this.remoteOutboundConnections;
        }
    }
}

