/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.embedder.PlexusLoggerAdapter;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractJarPluginTestCase
extends PlexusTestCase {
    protected final String FINAL_NAME_PREFIX = "maven-jar-plugin-test-";
    protected final String FINAL_NAME_SUFFIX = "-99.0";

    protected File executeMojo(String projectName, Properties properties) throws Exception {
        MavenEmbedder maven = new MavenEmbedder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        maven.setClassLoader(classLoader);
        maven.setLogger((MavenEmbedderLogger)new MavenEmbedderConsoleLogger());
        maven.setOffline(true);
        maven.start();
        File itbasedir = new File(AbstractJarPluginTestCase.getBasedir(), "target/test-classes/it/" + projectName);
        MavenProject pom = maven.readProjectWithDependencies(new File(itbasedir, "pom.xml"));
        DefaultEventMonitor eventMonitor = new DefaultEventMonitor((Logger)new PlexusLoggerAdapter((MavenEmbedderLogger)new MavenEmbedderConsoleLogger()));
        maven.execute(pom, Collections.singletonList("package"), (EventMonitor)eventMonitor, (TransferListener)new ConsoleDownloadMonitor(), properties, itbasedir);
        maven.stop();
        return itbasedir;
    }

    protected File doTestProject(String projectName, String classifier, String[] expectedArtifacts) throws Exception {
        File baseDir = this.executeMojo(projectName, new Properties());
        this.assertJarArchive(baseDir, projectName, classifier);
        this.assertArchiveContent(baseDir, projectName, classifier, expectedArtifacts);
        return baseDir;
    }

    protected void assertJarArchive(File baseDir, String projectName, String classifier) {
        AbstractJarPluginTestCase.assertTrue((String)"JAR archive does not exist", (boolean)this.getJarArchive(baseDir, projectName, classifier).exists());
    }

    protected File getTargetDirectory(File basedir) {
        return new File(basedir, "target");
    }

    protected File getJarArchive(File baseDir, String projectName, String classifier) {
        return new File(this.getTargetDirectory(baseDir), String.valueOf(this.buildFinalName(projectName, classifier)) + ".jar");
    }

    protected File getJarDirectory(File baseDir, String projectName, String classifier) {
        return new File(this.getTargetDirectory(baseDir), this.buildFinalName(projectName, classifier));
    }

    protected String buildFinalName(String projectName, String classifier) {
        if (classifier != null) {
            return "maven-jar-plugin-test-" + projectName + "-99.0" + "-" + classifier;
        }
        return "maven-jar-plugin-test-" + projectName + "-99.0";
    }

    protected void assertArchiveContent(File baseDir, String projectName, String classifier, String[] artifactNames) throws IOException {
        HashSet<String> contents = new HashSet<String>();
        JarFile jar = new JarFile(this.getJarArchive(baseDir, projectName, classifier));
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            if (entry.isDirectory()) continue;
            contents.add(entry.getName());
        }
        AbstractJarPluginTestCase.assertEquals((String)("Artifacts mismatch " + contents), (int)artifactNames.length, (int)contents.size());
        int i = 0;
        while (i < artifactNames.length) {
            String artifactName = artifactNames[i];
            AbstractJarPluginTestCase.assertTrue((String)("Artifact[" + artifactName + "] not found in jar archive"), (boolean)contents.contains(artifactName));
            ++i;
        }
    }
}

