/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final int CASE_OFFSET = 32;

    public static String getSetter(String s) {
        char[] chars = new char[s.length() + 3];
        chars[0] = 115;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = s.charAt(0) > 'Z' ? (char)(s.charAt(0) - 32) : s.charAt(0);
        for (int i = s.length() - 1; i != 0; --i) {
            chars[i + 3] = s.charAt(i);
        }
        return new String(chars);
    }

    public static String getGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 3];
        chars[0] = 103;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = c[0] > 'Z' ? (char)(c[0] - 32) : c[0];
        System.arraycopy(c, 1, chars, 4, c.length - 1);
        return new String(chars);
    }

    public static String getIsGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 2];
        chars[0] = 105;
        chars[1] = 115;
        chars[2] = c[0] > 'Z' ? (char)(c[0] - 32) : c[0];
        System.arraycopy(c, 1, chars, 3, c.length - 1);
        return new String(chars);
    }

    public static String getPropertyFromAccessor(String s) {
        char[] c = s.toCharArray();
        if (c.length > 3 && c[1] == 'e' && c[2] == 't') {
            char[] chars = new char[c.length - 3];
            if (c[0] == 'g' || c[0] == 's') {
                chars[0] = c[3] < 'a' ? (char)(c[3] + 32) : c[3];
                for (int i = 1; i < chars.length; ++i) {
                    chars[i] = c[i + 3];
                }
                return new String(chars);
            }
            return s;
        }
        if (c.length > 2 && c[0] == 'i' && c[1] == 's') {
            char[] chars = new char[c.length - 2];
            chars[0] = c[2] < 'a' ? (char)(c[2] + 32) : c[2];
            for (int i = 1; i < chars.length; ++i) {
                chars[i] = c[i + 2];
            }
            return new String(chars);
        }
        return s;
    }

    public static Class<?> toNonPrimitiveType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        return Boolean.class;
    }

    public static Class<?> toNonPrimitiveArray(Class<?> c) {
        if (!c.isArray() || !c.getComponentType().isPrimitive()) {
            return c;
        }
        if (c == int[].class) {
            return Integer[].class;
        }
        if (c == long[].class) {
            return Long[].class;
        }
        if (c == double[].class) {
            return Double[].class;
        }
        if (c == float[].class) {
            return Float[].class;
        }
        if (c == short[].class) {
            return Short[].class;
        }
        if (c == byte[].class) {
            return Byte[].class;
        }
        if (c == char[].class) {
            return Character[].class;
        }
        return Boolean[].class;
    }

    public static Class<?> toPrimitiveArrayType(Class<?> c) {
        if (!c.isPrimitive()) {
            throw new RuntimeException(c + " is not a primitive type");
        }
        if (c == Integer.TYPE) {
            return int[].class;
        }
        if (c == Long.TYPE) {
            return long[].class;
        }
        if (c == Double.TYPE) {
            return double[].class;
        }
        if (c == Float.TYPE) {
            return float[].class;
        }
        if (c == Short.TYPE) {
            return short[].class;
        }
        if (c == Byte.TYPE) {
            return byte[].class;
        }
        if (c == Character.TYPE) {
            return char[].class;
        }
        return boolean[].class;
    }

    public static boolean isAssignableFrom(Class<?> from, Class<?> to) {
        return from.isAssignableFrom(to) || ReflectionUtil.areBoxingCompatible(from, to);
    }

    private static boolean areBoxingCompatible(Class<?> c1, Class<?> c2) {
        return c1.isPrimitive() ? ReflectionUtil.isPrimitiveOf(c2, c1) : (c2.isPrimitive() ? ReflectionUtil.isPrimitiveOf(c1, c2) : false);
    }

    private static boolean isPrimitiveOf(Class<?> boxed, Class<?> primitive) {
        if (primitive == Integer.TYPE) {
            return boxed == Integer.class;
        }
        if (primitive == Long.TYPE) {
            return boxed == Long.class;
        }
        if (primitive == Double.TYPE) {
            return boxed == Double.class;
        }
        if (primitive == Float.TYPE) {
            return boxed == Float.class;
        }
        if (primitive == Short.TYPE) {
            return boxed == Short.class;
        }
        if (primitive == Byte.TYPE) {
            return boxed == Byte.class;
        }
        if (primitive == Character.TYPE) {
            return boxed == Character.class;
        }
        if (primitive == Boolean.TYPE) {
            return boxed == Boolean.class;
        }
        return false;
    }
}

