/*
 * Decompiled with CFR 0.152.
 */
package test.ejb;

import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;

public class MessageDrivenBean
implements javax.ejb.MessageDrivenBean,
MessageListener {
    private MessageDrivenContext context;

    public void ejbCreate() {
    }

    @Override
    public void setMessageDrivenContext(MessageDrivenContext context) {
        this.context = context;
    }

    @Override
    public void ejbRemove() {
    }

    @Override
    public void onMessage(Message message) {
        try {
            InitialContext namingContext = new InitialContext();
            QueueConnectionFactory qcf = (QueueConnectionFactory)namingContext.lookup("java:comp/env/jms/myQueueConnectionFactory");
            namingContext.close();
            QueueConnection queueConnection = qcf.createQueueConnection();
            QueueSession queueSession = queueConnection.createQueueSession(false, 1);
            QueueSender queueSender = queueSession.createSender(null);
            String txt = "mdb rcv: " + message.getJMSMessageID();
            System.out.println(txt + " redel=" + message.getJMSRedelivered() + " cnt=" + message.getIntProperty("JMSXDeliveryCount"));
            Message returnMessage = queueSession.createMessage();
            returnMessage.setStringProperty("RECIPIENT", "CLIENT");
            returnMessage.setIntProperty("count", message.getIntProperty("JMSXDeliveryCount"));
            returnMessage.setJMSCorrelationID(message.getJMSMessageID());
            Destination destination = message.getJMSReplyTo();
            queueSender.send((Queue)destination, returnMessage);
            System.out.println(txt + " snd: " + returnMessage.getJMSMessageID());
            queueConnection.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process message [" + message + "].", e);
        }
    }
}

