/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.MultiSegmentReader;
import org.apache.lucene.index.ReadOnlyMultiSegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

abstract class DirectoryIndexReader
extends IndexReader {
    protected Directory directory;
    protected boolean closeDirectory;
    private IndexDeletionPolicy deletionPolicy;
    private SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private final HashSet synced = new HashSet();
    private boolean rollbackHasChanges;
    private SegmentInfos rollbackSegmentInfos;
    protected boolean readOnly;
    static final /* synthetic */ boolean $assertionsDisabled;

    void init(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean readOnly) throws IOException {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.closeDirectory = closeDirectory;
        this.readOnly = readOnly;
        if (!readOnly && segmentInfos != null) {
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo info = segmentInfos.info(i);
                List files = info.files();
                for (int j = 0; j < files.size(); ++j) {
                    this.synced.add(files.get(j));
                }
            }
        }
    }

    protected DirectoryIndexReader() {
    }

    DirectoryIndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean readOnly) throws IOException {
        this.init(directory, segmentInfos, closeDirectory, readOnly);
    }

    static DirectoryIndexReader open(Directory directory, boolean closeDirectory, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return DirectoryIndexReader.open(directory, closeDirectory, deletionPolicy, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DirectoryIndexReader open(Directory directory, final boolean closeDirectory, final IndexDeletionPolicy deletionPolicy, IndexCommit commit, final boolean readOnly) throws CorruptIndexException, IOException {
        SegmentInfos.FindSegmentsFile finder = new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                DirectoryIndexReader reader = infos.size() == 1 ? SegmentReader.get(readOnly, infos, infos.info(0), false) : (readOnly ? new ReadOnlyMultiSegmentReader(this.directory, infos, false) : new MultiSegmentReader(this.directory, infos, false, false));
                reader.setDeletionPolicy(deletionPolicy);
                reader.closeDirectory = closeDirectory;
                return reader;
            }
        };
        DirectoryIndexReader reader = null;
        try {
            if (commit == null) {
                reader = (DirectoryIndexReader)finder.run();
            } else {
                if (directory != commit.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                reader = (DirectoryIndexReader)finder.doBody(commit.getSegmentsFileName());
            }
            Object var8_7 = null;
            if (reader != null || !closeDirectory) return reader;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader != null || !closeDirectory) throw throwable;
            try {
                directory.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            directory.close();
            return reader;
        }
        catch (IOException ioe) {}
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        DirectoryIndexReader reader;
        block8: {
            this.ensureOpen();
            if (this.hasChanges || this.isCurrent()) {
                return this;
            }
            SegmentInfos.FindSegmentsFile finder = new SegmentInfos.FindSegmentsFile(this.directory){

                protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                    SegmentInfos infos = new SegmentInfos();
                    infos.read(this.directory, segmentFileName);
                    DirectoryIndexReader newReader = DirectoryIndexReader.this.doReopen(infos);
                    if (DirectoryIndexReader.this != newReader) {
                        newReader.init(this.directory, infos, DirectoryIndexReader.this.closeDirectory, DirectoryIndexReader.this.readOnly);
                        newReader.deletionPolicy = DirectoryIndexReader.this.deletionPolicy;
                    }
                    return newReader;
                }
            };
            reader = null;
            boolean myCloseDirectory = this.closeDirectory;
            this.closeDirectory = false;
            try {
                reader = (DirectoryIndexReader)finder.run();
                Object var5_4 = null;
                if (!myCloseDirectory) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (myCloseDirectory) {
                    if (!$assertionsDisabled && !(this.directory instanceof FSDirectory)) {
                        throw new AssertionError();
                    }
                    this.closeDirectory = true;
                    if (reader != null && reader != this) {
                        reader.closeDirectory = true;
                        reader.directory = FSDirectory.getDirectory(((FSDirectory)this.directory).getFile());
                    }
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !(this.directory instanceof FSDirectory)) {
                throw new AssertionError();
            }
            this.closeDirectory = true;
            if (reader != null && reader != this) {
                reader.closeDirectory = true;
                reader.directory = FSDirectory.getDirectory(((FSDirectory)this.directory).getFile());
            }
        }
        return reader;
    }

    protected abstract DirectoryIndexReader doReopen(SegmentInfos var1) throws CorruptIndexException, IOException;

    public void setDeletionPolicy(IndexDeletionPolicy deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
    }

    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    protected void doClose() throws IOException {
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() throws IOException {
        if (this.hasChanges) {
            if (this.segmentInfos != null) {
                IndexFileDeleter deleter;
                block10: {
                    deleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
                    this.startCommit();
                    boolean success = false;
                    try {
                        this.commitChanges();
                        for (int i = 0; i < this.segmentInfos.size(); ++i) {
                            SegmentInfo info = this.segmentInfos.info(i);
                            List files = info.files();
                            for (int j = 0; j < files.size(); ++j) {
                                String fileName = (String)files.get(j);
                                if (this.synced.contains(fileName)) continue;
                                if (!$assertionsDisabled && !this.directory.fileExists(fileName)) {
                                    throw new AssertionError();
                                }
                                this.directory.sync(fileName);
                                this.synced.add(fileName);
                            }
                        }
                        this.segmentInfos.commit(this.directory);
                        success = true;
                        Object var9_8 = null;
                        if (success) break block10;
                        this.rollbackCommit();
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (!success) {
                            this.rollbackCommit();
                            deleter.refresh();
                        }
                        throw throwable;
                    }
                    deleter.refresh();
                    {
                    }
                }
                deleter.checkpoint(this.segmentInfos, true);
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.commitChanges();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void commitChanges() throws IOException;

    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock writeLock = this.directory.makeLock("write.lock");
                if (!writeLock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    void startCommit() {
        if (this.segmentInfos != null) {
            this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        }
        this.rollbackHasChanges = this.hasChanges;
    }

    void rollbackCommit() {
        if (this.segmentInfos != null) {
            for (int i = 0; i < this.segmentInfos.size(); ++i) {
                this.segmentInfos.info(i).reset(this.rollbackSegmentInfos.info(i));
            }
            this.rollbackSegmentInfos = null;
        }
        this.hasChanges = this.rollbackHasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public IndexCommit getIndexCommit() throws IOException {
        return new ReaderCommit(this.segmentInfos, this.directory);
    }

    public static Collection listCommits(Directory dir) throws IOException {
        String[] files = dir.list();
        if (files == null) {
            throw new IOException("cannot read directory " + dir + ": list() returned null");
        }
        ArrayList<ReaderCommit> commits = new ArrayList<ReaderCommit>();
        SegmentInfos latest = new SegmentInfos();
        latest.read(dir);
        long currentGen = latest.getGeneration();
        commits.add(new ReaderCommit(latest, dir));
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!fileName.startsWith("segments") || fileName.equals("segments.gen") || SegmentInfos.generationFromSegmentsFileName(fileName) >= currentGen) continue;
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(dir, fileName);
            }
            catch (FileNotFoundException fnfe) {
                sis = null;
            }
            if (sis == null) continue;
            commits.add(new ReaderCommit(sis, dir));
        }
        return commits;
    }

    static {
        $assertionsDisabled = !DirectoryIndexReader.class.desiredAssertionStatus();
    }

    private static class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection files;
        Directory dir;
        long generation;
        long version;
        final boolean isOptimized;

        ReaderCommit(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getCurrentSegmentFileName();
            this.dir = dir;
            int size = infos.size();
            this.files = new ArrayList(size);
            this.files.add(this.segmentsFileName);
            for (int i = 0; i < size; ++i) {
                SegmentInfo info = infos.info(i);
                if (info.dir != dir) continue;
                this.files.addAll(info.files());
            }
            this.version = infos.getVersion();
            this.generation = infos.getGeneration();
            this.isOptimized = infos.size() == 1 && !infos.info(0).hasDeletions();
        }

        public boolean isOptimized() {
            return this.isOptimized;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getVersion() {
            return this.version;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }
    }
}

