/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReadOnlyMultiSegmentReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;

class MultiSegmentReader
extends DirectoryIndexReader {
    protected SegmentReader[] subReaders;
    private int[] starts;
    private Map normsCache = new HashMap();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    MultiSegmentReader(Directory directory, SegmentInfos sis, boolean closeDirectory, boolean readOnly) throws IOException {
        super(directory, sis, closeDirectory, readOnly);
        SegmentReader[] readers = new SegmentReader[sis.size()];
        for (int i = sis.size() - 1; i >= 0; --i) {
            try {
                readers[i] = SegmentReader.get(readOnly, sis.info(i));
                continue;
            }
            catch (IOException e) {
                ++i;
                while (i < sis.size()) {
                    try {
                        readers[i].close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    ++i;
                }
                throw e;
            }
        }
        this.initialize(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiSegmentReader(Directory directory, SegmentInfos infos, boolean closeDirectory, SegmentReader[] oldReaders, int[] oldStarts, Map oldNormsCache, boolean readOnly) throws IOException {
        super(directory, infos, closeDirectory, readOnly);
        HashMap<String, Integer> segmentReaders = new HashMap<String, Integer>();
        if (oldReaders != null) {
            for (int i = 0; i < oldReaders.length; ++i) {
                segmentReaders.put(oldReaders[i].getSegmentName(), new Integer(i));
            }
        }
        SegmentReader[] newReaders = new SegmentReader[infos.size()];
        boolean[] readerShared = new boolean[infos.size()];
        for (int i = infos.size() - 1; i >= 0; --i) {
            IOException ignore2;
            Object var16_19;
            Integer oldReaderIndex = (Integer)segmentReaders.get(infos.info((int)i).name);
            newReaders[i] = oldReaderIndex == null ? null : oldReaders[oldReaderIndex];
            boolean success = false;
            try {
                SegmentReader newReader = newReaders[i] == null || infos.info(i).getUseCompoundFile() != newReaders[i].getSegmentInfo().getUseCompoundFile() ? SegmentReader.get(readOnly, infos.info(i)) : newReaders[i].reopenSegment(infos.info(i));
                if (newReader == newReaders[i]) {
                    readerShared[i] = true;
                    newReader.incRef();
                } else {
                    readerShared[i] = false;
                    newReaders[i] = newReader;
                }
                success = true;
                var16_19 = null;
                if (success) continue;
                ++i;
            }
            catch (Throwable throwable) {
                var16_19 = null;
                if (!success) {
                    ++i;
                    while (i < infos.size()) {
                        if (newReaders[i] != null) {
                            try {
                                if (!readerShared[i]) {
                                    newReaders[i].close();
                                } else {
                                    newReaders[i].decRef();
                                }
                            }
                            catch (IOException ignore2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                throw throwable;
            }
            while (i < infos.size()) {
                if (newReaders[i] != null) {
                    try {
                        if (!readerShared[i]) {
                            newReaders[i].close();
                        } else {
                            newReaders[i].decRef();
                        }
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                }
                ++i;
            }
            continue;
        }
        this.initialize(newReaders);
        if (oldNormsCache != null) {
            Iterator it = oldNormsCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String field = (String)entry.getKey();
                if (!this.hasNorms(field)) continue;
                byte[] oldBytes = (byte[])entry.getValue();
                byte[] bytes = new byte[this.maxDoc()];
                for (int i = 0; i < this.subReaders.length; ++i) {
                    Integer oldReaderIndex = (Integer)segmentReaders.get(this.subReaders[i].getSegmentName());
                    if (oldReaderIndex != null && (oldReaders[oldReaderIndex] == this.subReaders[i] || oldReaders[oldReaderIndex.intValue()].norms.get(field) == this.subReaders[i].norms.get(field))) {
                        System.arraycopy(oldBytes, oldStarts[oldReaderIndex], bytes, this.starts[i], this.starts[i + 1] - this.starts[i]);
                        continue;
                    }
                    this.subReaders[i].norms(field, bytes, this.starts[i]);
                }
                this.normsCache.put(field, bytes);
            }
        }
    }

    private void initialize(SegmentReader[] subReaders) {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    protected synchronized DirectoryIndexReader doReopen(SegmentInfos infos) throws CorruptIndexException, IOException {
        if (infos.size() == 1) {
            return SegmentReader.get(this.readOnly, infos, infos.info(0), false);
        }
        if (this.readOnly) {
            return new ReadOnlyMultiSegmentReader(this.directory, infos, this.closeDirectory, this.subReaders, this.starts, this.normsCache);
        }
        return new MultiSegmentReader(this.directory, infos, this.closeDirectory, this.subReaders, this.starts, this.normsCache, false);
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    public boolean isOptimized() {
        return false;
    }

    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return MultiSegmentReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    static final int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes == null && !this.hasNorms(field)) {
            bytes = this.fakeNorms();
        }
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        Map map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(field);
        }
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    protected void commitChanges() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    void startCommit() {
        super.startCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    void rollbackCommit() {
        super.rollbackCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].decRef();
        }
        super.doClose();
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return MultiSegmentReader.getFieldNames(fieldNames, this.subReaders);
    }

    static Collection getFieldNames(IndexReader.FieldOption fieldNames, IndexReader[] subReaders) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < subReaders.length; ++i) {
            IndexReader reader = subReaders[i];
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    SegmentReader[] getSubReaders() {
        return this.subReaders;
    }

    public void setTermInfosIndexDivisor(int indexDivisor) throws IllegalStateException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].setTermInfosIndexDivisor(indexDivisor);
        }
    }

    public int getTermInfosIndexDivisor() throws IllegalStateException {
        if (this.subReaders.length > 0) {
            return this.subReaders[0].getTermInfosIndexDivisor();
        }
        throw new IllegalStateException("no readers");
    }

    static class MultiTermPositions
    extends MultiTermDocs
    implements TermPositions {
        public MultiTermPositions(IndexReader[] r, int[] s) {
            super(r, s);
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termPositions();
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.current).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.current).getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.current).getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.current).isPayloadAvailable();
        }
    }

    static class MultiTermDocs
    implements TermDocs {
        protected IndexReader[] readers;
        protected int[] starts;
        protected Term term;
        protected int base = 0;
        protected int pointer = 0;
        private TermDocs[] readerTermDocs;
        protected TermDocs current;

        public MultiTermDocs(IndexReader[] r, int[] s) {
            this.readers = r;
            this.starts = s;
            this.readerTermDocs = new TermDocs[r.length];
        }

        public int doc() {
            return this.base + this.current.doc();
        }

        public int freq() {
            return this.current.freq();
        }

        public void seek(Term term) {
            this.term = term;
            this.base = 0;
            this.pointer = 0;
            this.current = null;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        public boolean next() throws IOException {
            while (true) {
                if (this.current != null && this.current.next()) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int end;
            while (true) {
                if (this.current == null) {
                    if (this.pointer < this.readers.length) {
                        this.base = this.starts[this.pointer];
                        this.current = this.termDocs(this.pointer++);
                        continue;
                    }
                    return 0;
                }
                end = this.current.read(docs, freqs);
                if (end != 0) break;
                this.current = null;
            }
            int b = this.base;
            int i = 0;
            while (i < end) {
                int n = i++;
                docs[n] = docs[n] + b;
            }
            return end;
        }

        public boolean skipTo(int target) throws IOException {
            while (true) {
                if (this.current != null && this.current.skipTo(target - this.base)) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        private TermDocs termDocs(int i) throws IOException {
            if (this.term == null) {
                return null;
            }
            TermDocs result = this.readerTermDocs[i];
            if (result == null) {
                result = this.readerTermDocs[i] = this.termDocs(this.readers[i]);
            }
            result.seek(this.term);
            return result;
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termDocs();
        }

        public void close() throws IOException {
            for (int i = 0; i < this.readerTermDocs.length; ++i) {
                if (this.readerTermDocs[i] == null) continue;
                this.readerTermDocs[i].close();
            }
        }
    }

    static class MultiTermEnum
    extends TermEnum {
        private SegmentMergeQueue queue;
        private Term term;
        private int docFreq;

        public MultiTermEnum(IndexReader[] readers, int[] starts, Term t) throws IOException {
            this.queue = new SegmentMergeQueue(readers.length);
            for (int i = 0; i < readers.length; ++i) {
                IndexReader reader = readers[i];
                TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
                SegmentMergeInfo smi = new SegmentMergeInfo(starts[i], termEnum, reader);
                if (t == null ? smi.next() : termEnum.term() != null) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
            if (t != null && this.queue.size() > 0) {
                this.next();
            }
        }

        public boolean next() throws IOException {
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            if (top == null) {
                this.term = null;
                return false;
            }
            this.term = top.term;
            this.docFreq = 0;
            while (top != null && this.term.compareTo(top.term) == 0) {
                this.queue.pop();
                this.docFreq += top.termEnum.docFreq();
                if (top.next()) {
                    this.queue.put(top);
                } else {
                    top.close();
                }
                top = (SegmentMergeInfo)this.queue.top();
            }
            return true;
        }

        public Term term() {
            return this.term;
        }

        public int docFreq() {
            return this.docFreq;
        }

        public void close() throws IOException {
            this.queue.close();
        }
    }
}

