/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockReleaseFailedException;

class NativeFSLock
extends Lock {
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static HashSet LOCK_HELD = new HashSet();

    public NativeFSLock(File lockDir, String lockFileName) {
        this.lockDir = lockDir;
        this.path = new File(lockDir, lockFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean obtain() throws IOException {
        boolean markedHeld;
        String canonicalPath;
        block31: {
            HashSet hashSet;
            boolean bl;
            block30: {
                if (this.isLocked()) {
                    return false;
                }
                if (!this.lockDir.exists()) {
                    if (!this.lockDir.mkdirs()) {
                        throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
                    }
                } else if (!this.lockDir.isDirectory()) {
                    throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
                }
                canonicalPath = this.path.getCanonicalPath();
                markedHeld = false;
                try {
                    HashSet hashSet2 = LOCK_HELD;
                    synchronized (hashSet2) {
                        if (LOCK_HELD.contains(canonicalPath)) {
                            bl = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 10, 29] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                            Object var15_7 = null;
                            if (!markedHeld) return bl;
                            if (this.isLocked()) return bl;
                            hashSet = LOCK_HELD;
                            break block30;
                        }
                        LOCK_HELD.add(canonicalPath);
                        markedHeld = true;
                    }
                    try {
                        this.f = new RandomAccessFile(this.path, "rw");
                    }
                    catch (IOException e) {
                        this.failureReason = e;
                        this.f = null;
                    }
                    if (this.f == null) break block31;
                    try {
                        block32: {
                            this.channel = this.f.getChannel();
                            try {
                                try {
                                    this.lock = this.channel.tryLock();
                                }
                                catch (IOException e) {
                                    this.failureReason = e;
                                    Object var7_14 = null;
                                    if (this.lock != null) break block32;
                                    try {
                                        this.channel.close();
                                        Object var9_18 = null;
                                        this.channel = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_19 = null;
                                        this.channel = null;
                                        throw throwable;
                                    }
                                }
                                Object var7_13 = null;
                                if (this.lock != null) break block32;
                            }
                            catch (Throwable throwable) {
                                Object var7_15 = null;
                                if (this.lock != null) throw throwable;
                                try {}
                                catch (Throwable throwable2) {
                                    Object var9_21 = null;
                                    this.channel = null;
                                    throw throwable2;
                                }
                                this.channel.close();
                                Object var9_20 = null;
                                this.channel = null;
                                throw throwable;
                            }
                            try {}
                            catch (Throwable throwable) {
                                Object var9_17 = null;
                                this.channel = null;
                                throw throwable;
                            }
                            this.channel.close();
                            Object var9_16 = null;
                            this.channel = null;
                        }
                        Object var11_26 = null;
                        if (this.channel != null) break block31;
                    }
                    catch (Throwable throwable) {
                        Object var11_27 = null;
                        if (this.channel != null) throw throwable;
                        try {
                            this.f.close();
                            Object var13_30 = null;
                            this.f = null;
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            Object var13_31 = null;
                            this.f = null;
                            throw throwable3;
                        }
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var13_29 = null;
                        this.f = null;
                        throw throwable;
                    }
                    this.f.close();
                    Object var13_28 = null;
                    this.f = null;
                    break block31;
                }
                catch (Throwable throwable) {
                    Object var15_9 = null;
                    if (!markedHeld) throw throwable;
                    if (this.isLocked()) throw throwable;
                    HashSet hashSet3 = LOCK_HELD;
                    synchronized (hashSet3) {
                        if (!LOCK_HELD.contains(canonicalPath)) throw throwable;
                        LOCK_HELD.remove(canonicalPath);
                        throw throwable;
                    }
                }
            }
            synchronized (hashSet) {
                if (!LOCK_HELD.contains(canonicalPath)) return bl;
                LOCK_HELD.remove(canonicalPath);
                return bl;
            }
        }
        Object var15_8 = null;
        if (!markedHeld) return this.isLocked();
        if (this.isLocked()) return this.isLocked();
        HashSet hashSet = LOCK_HELD;
        synchronized (hashSet) {
            if (!LOCK_HELD.contains(canonicalPath)) return this.isLocked();
            LOCK_HELD.remove(canonicalPath);
            return this.isLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws IOException {
        if (this.isLocked()) {
            Object v3;
            try {
                this.lock.release();
                Object var2_1 = null;
                this.lock = null;
            }
            catch (Throwable throwable) {
                Object v1;
                Object var2_2 = null;
                this.lock = null;
                try {
                    this.channel.close();
                    Object var4_5 = null;
                    this.channel = null;
                }
                catch (Throwable throwable2) {
                    Object v0;
                    Object var4_6 = null;
                    this.channel = null;
                    try {
                        this.f.close();
                        v0 = null;
                    }
                    catch (Throwable throwable3) {
                        v0 = null;
                    }
                    Object var6_14 = v0;
                    this.f = null;
                    HashSet hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        LOCK_HELD.remove(this.path.getCanonicalPath());
                    }
                    throw throwable2;
                }
                try {
                    this.f.close();
                    v1 = null;
                }
                catch (Throwable throwable4) {
                    v1 = null;
                }
                Object var6_13 = v1;
                this.f = null;
                HashSet hashSet = LOCK_HELD;
                synchronized (hashSet) {
                    LOCK_HELD.remove(this.path.getCanonicalPath());
                }
                throw throwable;
            }
            try {
                this.channel.close();
                Object var4_3 = null;
                this.channel = null;
            }
            catch (Throwable throwable) {
                Object v2;
                Object var4_4 = null;
                this.channel = null;
                try {
                    this.f.close();
                    v2 = null;
                }
                catch (Throwable throwable5) {
                    v2 = null;
                }
                Object var6_12 = v2;
                this.f = null;
                HashSet hashSet = LOCK_HELD;
                synchronized (hashSet) {
                    LOCK_HELD.remove(this.path.getCanonicalPath());
                }
                throw throwable;
            }
            try {
                this.f.close();
                v3 = null;
            }
            catch (Throwable throwable) {
                v3 = null;
            }
            Object var6_11 = v3;
            this.f = null;
            HashSet hashSet = LOCK_HELD;
            synchronized (hashSet) {
                LOCK_HELD.remove(this.path.getCanonicalPath());
            }
            if (!this.path.delete()) {
                throw new LockReleaseFailedException("failed to delete " + this.path);
            }
        }
    }

    public synchronized boolean isLocked() {
        return this.lock != null;
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.isLocked()) {
                this.release();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

