/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.pattern;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

public class PatternComponent
implements ResourceComponent,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    int count = 0;
    int traitCount = 0;
    int number = 0;
    int numberForTrait = 0;
    int[] wanted = new int[2];
    long delay = 0L;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException {
        Configuration conf = context.getPluginConfiguration();
        String tmp = conf.getSimpleValue("ones", "1");
        int wantedOnes = Integer.parseInt(tmp);
        if (wantedOnes < 1) {
            throw new InvalidPluginConfigurationException("Ones must be > 0");
        }
        tmp = conf.getSimpleValue("zeros", "1");
        int wantedZeros = Integer.parseInt(tmp);
        if (wantedZeros < 1) {
            throw new InvalidPluginConfigurationException("Zeros must be > 0");
        }
        this.wanted[0] = wantedZeros;
        this.wanted[1] = wantedOnes;
        tmp = conf.getSimpleValue("delay", "0");
        this.delay = Long.parseLong(tmp);
        if (this.delay < 0L) {
            this.delay = 0L;
        }
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        if (this.delay > 0L) {
            Thread.sleep(this.delay * 1000L);
        }
        boolean flipMetrics = false;
        boolean flipTraits = false;
        for (MeasurementScheduleRequest request : requests) {
            double value;
            String metricName = request.getName();
            if (metricName.startsWith("pattern")) {
                if (metricName.equals("pattern1")) {
                    value = this.number;
                    flipMetrics = true;
                } else {
                    value = 1 - this.number;
                }
                MeasurementDataNumeric datum = new MeasurementDataNumeric(request, Double.valueOf(value));
                report.addData(datum);
                continue;
            }
            if (!metricName.startsWith("text")) continue;
            if (metricName.equals("text1")) {
                value = this.numberForTrait;
                flipTraits = true;
            } else {
                value = 1 - this.numberForTrait;
            }
            String traitValue = value == 0.0 ? "red" : "green";
            MeasurementDataTrait datum = new MeasurementDataTrait(request, traitValue);
            report.addData(datum);
        }
        if (flipMetrics) {
            ++this.count;
            if (this.count >= this.wanted[this.number]) {
                this.number = 1 - this.number;
                this.count = 0;
            }
        }
        if (flipTraits) {
            ++this.traitCount;
            if (this.traitCount >= this.wanted[this.numberForTrait]) {
                this.numberForTrait = 1 - this.numberForTrait;
                this.traitCount = 0;
            }
        }
    }
}

