/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.filters;

import java.util.Objects;
import org.openrewrite.tools.checkstyle.filters.IntFilterElement;

class IntRangeFilterElement
implements IntFilterElement {
    private final Integer lowerBound;
    private final Integer upperBound;

    IntRangeFilterElement(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean accept(int intValue) {
        return this.lowerBound.compareTo(intValue) <= 0 && this.upperBound.compareTo(intValue) >= 0;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntRangeFilterElement intRangeFilter = (IntRangeFilterElement)other;
        return Objects.equals(this.lowerBound, intRangeFilter.lowerBound) && Objects.equals(this.upperBound, intRangeFilter.upperBound);
    }
}

