/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import java.util.Iterator;
import java.util.List;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleSession;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.jcp.jsr94.tck.util.TestFactory;

public class RuleRuntimeTest
extends TestCase {
    public RuleRuntimeTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testRuleRuntime() {
        try {
            String statelessUri = "tck_res_1.xml";
            String statefulUri = "tck_res_2.xml";
            RuleServiceProvider serviceProvider = TestCaseUtil.getRuleServiceProvider("ruleRuntimeTest");
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] RuleServiceProvider not found.", (Object)serviceProvider);
            RuleAdministrator ruleAdministrator = serviceProvider.getRuleAdministrator();
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] RuleAdministrator not found.", (Object)ruleAdministrator);
            RuleExecutionSet res = TestFactory.newInstance().createRuleExecutionSet(serviceProvider, statelessUri);
            ruleAdministrator.registerRuleExecutionSet(statelessUri, res, TestFactory.newInstance().createRegisterRuleExecutionSetMap());
            res = TestFactory.newInstance().createRuleExecutionSet(serviceProvider, statefulUri);
            ruleAdministrator.registerRuleExecutionSet(statefulUri, res, TestFactory.newInstance().createRegisterRuleExecutionSetMap());
            RuleRuntime ruleRuntime = serviceProvider.getRuleRuntime();
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] RuleRuntime not created.", (Object)ruleRuntime);
            List registrations = ruleRuntime.getRegistrations();
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] No registrations found.", (Object)registrations);
            RuleRuntimeTest.assertTrue((String)"[RuleRuntimeTest] Not all registrations found.", (2 <= registrations.size() ? 1 : 0) != 0);
            Iterator itr = registrations.iterator();
            int countRegistrations = 0;
            while (itr.hasNext()) {
                Object next = itr.next();
                RuleRuntimeTest.assertTrue((String)"Iterator element instanceof String", (boolean)(next instanceof String));
                String name = (String)next;
                if (statelessUri.equals(name)) {
                    ++countRegistrations;
                }
                if (!statefulUri.equals(name)) continue;
                ++countRegistrations;
            }
            RuleRuntimeTest.assertEquals((String)"[RuleRuntimeTest] Not all registrations found.", (int)2, (int)countRegistrations);
            RuleSession ruleSession = null;
            ruleSession = ruleRuntime.createRuleSession(statelessUri, TestFactory.newInstance().createRuleSessionMap(1), 1);
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] Stateless rule session could not be created.", (Object)ruleSession);
            RuleRuntimeTest.assertTrue((String)"[RuleRuntimeTest] Rule session is not of Stateless type.", (boolean)(ruleSession instanceof StatelessRuleSession));
            ruleSession = ruleRuntime.createRuleSession(statefulUri, TestFactory.newInstance().createRuleSessionMap(0), 0);
            RuleRuntimeTest.assertNotNull((String)"[RuleRuntimeTest] Stateful rule session could not be created.", (Object)ruleSession);
            RuleRuntimeTest.assertTrue((String)"[RuleRuntimeTest] Rule session is not of Stateful type.", (boolean)(ruleSession instanceof StatefulRuleSession));
        }
        catch (Exception e) {
            TestCaseUtil.processTestException(e, this, "testRuleRuntime");
        }
    }
}

