/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;

public class DbEnvPool {
    private static DbEnvPool pool = new DbEnvPool();
    private Map envs = new Hashtable();

    private DbEnvPool() {
    }

    public static DbEnvPool getInstance() {
        return pool;
    }

    public synchronized EnvironmentImplInfo getEnvironment(File dbEnvHome, EnvironmentConfig config) throws DatabaseException {
        boolean firstHandle = false;
        EnvironmentImpl environmentImpl = null;
        if (this.envs.containsKey(dbEnvHome)) {
            environmentImpl = (EnvironmentImpl)this.envs.get(dbEnvHome);
            if (!environmentImpl.isOpen()) {
                environmentImpl.open();
            }
        } else {
            environmentImpl = new EnvironmentImpl(dbEnvHome, config);
            this.envs.put(dbEnvHome, environmentImpl);
            firstHandle = true;
        }
        return new EnvironmentImplInfo(environmentImpl, firstHandle);
    }

    void remove(File dbEnvHome) {
        this.envs.remove(dbEnvHome);
    }

    public void clear() {
        this.envs.clear();
    }

    public static class EnvironmentImplInfo {
        public EnvironmentImpl envImpl;
        public boolean firstHandle = false;

        EnvironmentImplInfo(EnvironmentImpl envImpl, boolean firstHandle) {
            this.envImpl = envImpl;
            this.firstHandle = firstHandle;
        }
    }
}

