/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.incomp;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class INCompressor
extends DaemonThread {
    private static final String TRACE_COMPRESS = "INCompress:";
    private EnvironmentImpl env;
    private long lockTimeout;
    private int splitBins = 0;
    private int dbClosedBins = 0;
    private int cursorsBins = 0;
    private int nonEmptyBins = 0;
    private int processedBins = 0;
    private Map binRefQueue;
    private Latch binRefQueueLatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    public INCompressor(EnvironmentImpl env, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.COMPRESSOR_LOCK_TIMEOUT));
        this.binRefQueue = new HashMap();
        this.binRefQueueLatch = new Latch(name + " BINReference queue", env);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<INCompressor name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyCursors() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ArrayList queueSnapshot = null;
        try {
            this.binRefQueueLatch.acquire();
            queueSnapshot = new ArrayList(this.binRefQueue.values());
        }
        finally {
            if (this.binRefQueueLatch.isOwner()) {
                this.binRefQueueLatch.release();
            }
        }
        Iterator it = queueSnapshot.iterator();
        while (it.hasNext()) {
            BINReference binRef = (BINReference)it.next();
            DatabaseImpl db = this.env.getDbMapTree().getDb(binRef.getDatabaseId(), this.lockTimeout);
            BIN bin = this.searchForBIN(db, binRef);
            if (bin == null) continue;
            bin.verifyCursors();
            bin.getLatch().release();
        }
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("INCompressor.addToQueue should never be called.");
    }

    public int getBinRefQueueSize() throws DatabaseException {
        this.binRefQueueLatch.acquire();
        int size = this.binRefQueue.size();
        this.binRefQueueLatch.release();
        return size;
    }

    public void addBinKeyToQueue(BIN bin, Key deletedKey) throws DatabaseException {
        this.binRefQueueLatch.acquire();
        this.addBinKeyToQueueAlreadyLatched(bin, deletedKey);
        this.binRefQueueLatch.release();
        this.wakeup();
    }

    public void addBinRefToQueue(BINReference binRef) throws DatabaseException {
        this.binRefQueueLatch.acquire();
        this.addBinRefToQueueAlreadyLatched(binRef);
        this.binRefQueueLatch.release();
        this.wakeup();
    }

    public void addMultipleBinRefsToQueue(Collection binRefs) throws DatabaseException {
        this.binRefQueueLatch.acquire();
        Iterator it = binRefs.iterator();
        while (it.hasNext()) {
            BINReference binRef = (BINReference)it.next();
            this.addBinRefToQueueAlreadyLatched(binRef);
        }
        this.binRefQueueLatch.release();
        this.wakeup();
    }

    private void addBinRefToQueueAlreadyLatched(BINReference binRef) {
        Long node = new Long(binRef.getNodeId());
        BINReference existingRef = (BINReference)this.binRefQueue.get(node);
        if (existingRef != null) {
            existingRef.addDeletedKeys(binRef);
        } else {
            this.binRefQueue.put(node, binRef);
        }
    }

    private void addBinKeyToQueueAlreadyLatched(BIN bin, Key deletedKey) {
        Long node = new Long(bin.getNodeId());
        BINReference existingRef = (BINReference)this.binRefQueue.get(node);
        if (existingRef != null) {
            if (deletedKey != null) {
                existingRef.addDeletedKey(deletedKey);
            }
        } else {
            BINReference binRef = bin.createReference();
            if (deletedKey != null) {
                binRef.addDeletedKey(deletedKey);
            }
            this.binRefQueue.put(node, binRef);
        }
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setSplitBins(this.splitBins);
        stat.setDbClosedBins(this.dbClosedBins);
        stat.setCursorsBins(this.cursorsBins);
        stat.setNonEmptyBins(this.nonEmptyBins);
        stat.setProcessedBins(this.processedBins);
        stat.setInCompQueueSize(this.getBinRefQueueSize());
        if (config.getClear()) {
            this.splitBins = 0;
            this.dbClosedBins = 0;
            this.cursorsBins = 0;
            this.nonEmptyBins = 0;
            this.processedBins = 0;
        }
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.COMPRESSOR_RETRY);
    }

    public synchronized void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        this.doCompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doCompress() throws DatabaseException {
        ArrayList<Long> cursorsBinList;
        int processedBinsThisRun;
        int nonEmptyBinsThisRun;
        int cursorsBinsThisRun;
        int dbClosedBinsThisRun;
        int splitBinsThisRun;
        block45: {
            block40: {
                block41: {
                    if (!this.isRunnable()) {
                        return;
                    }
                    Map queueSnapshot = null;
                    try {
                        this.binRefQueueLatch.acquire();
                        queueSnapshot = this.binRefQueue;
                        this.binRefQueue = new HashMap();
                    }
                    finally {
                        if (this.binRefQueueLatch.isOwner()) {
                            this.binRefQueueLatch.release();
                        }
                    }
                    splitBinsThisRun = 0;
                    dbClosedBinsThisRun = 0;
                    cursorsBinsThisRun = 0;
                    nonEmptyBinsThisRun = 0;
                    processedBinsThisRun = 0;
                    cursorsBinList = new ArrayList<Long>();
                    Tracer.trace(Level.FINE, this.env, "InCompress.doCompress called, queue size: " + queueSnapshot.size());
                    if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                        throw new AssertionError();
                    }
                    INList inList = this.env.getInMemoryINs();
                    try {
                        try {
                            Iterator it = queueSnapshot.values().iterator();
                            while (it.hasNext()) {
                                HashSet modifiedFileSummaries;
                                block44: {
                                    BINReference binRef = (BINReference)it.next();
                                    if (this.env.isClosed()) {
                                        Object var21_25 = null;
                                        if ($assertionsDisabled) break block40;
                                        break block41;
                                    }
                                    DbTree dbTree = this.env.getDbMapTree();
                                    DatabaseImpl db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout);
                                    if (db == null) {
                                        ++dbClosedBinsThisRun;
                                        continue;
                                    }
                                    modifiedFileSummaries = null;
                                    try {
                                        inList.latchMajor();
                                        Tracer.trace(Level.FINEST, this.env, "Compressing " + binRef);
                                        boolean empty = false;
                                        BIN bin = null;
                                        Key idKey = null;
                                        try {
                                            bin = this.searchForBIN(db, binRef);
                                            if (bin == null || bin.getNodeId() != binRef.getNodeId()) {
                                                ++splitBinsThisRun;
                                                continue;
                                            }
                                            idKey = bin.getIdentifierKey();
                                            int nCursors = bin.nCursors();
                                            if (nCursors > 0) {
                                                this.addBinRefToQueue(binRef);
                                                ++cursorsBinsThisRun;
                                                cursorsBinList.add(new Long(bin.getNodeId()));
                                                continue;
                                            }
                                            empty = bin.compress(binRef);
                                        }
                                        finally {
                                            if (bin == null) continue;
                                            bin.releaseLatch();
                                            continue;
                                        }
                                        if (empty) {
                                            block43: {
                                                try {
                                                    Tree tree = db.getTree();
                                                    modifiedFileSummaries = new HashSet();
                                                    if (bin.containsDuplicates()) {
                                                        DBIN dbin = (DBIN)bin;
                                                        if (!tree.deleteDup(idKey, dbin.getDupKey(), modifiedFileSummaries)) {
                                                            this.addBinRefToQueue(binRef);
                                                            ++cursorsBinsThisRun;
                                                            break block43;
                                                        } else {
                                                            ++processedBinsThisRun;
                                                        }
                                                        break block43;
                                                    }
                                                    boolean deletedRoot = tree.delete(idKey, modifiedFileSummaries);
                                                    if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                                                        throw new AssertionError();
                                                    }
                                                    if (deletedRoot) {
                                                        inList.releaseMajorLatchIfHeld();
                                                        dbTree.modifyDbRoot(db);
                                                        Tracer.traceRootDeletion(Level.FINE, db);
                                                        inList.latchMajor();
                                                    }
                                                    ++processedBinsThisRun;
                                                }
                                                catch (NodeNotEmptyException NNEE) {
                                                    ++nonEmptyBinsThisRun;
                                                }
                                            }
                                            if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                                                throw new AssertionError();
                                            }
                                            break block44;
                                        }
                                        ++nonEmptyBinsThisRun;
                                    }
                                    finally {
                                        inList.releaseMajorLatchIfHeld();
                                        continue;
                                    }
                                }
                                if (modifiedFileSummaries == null) continue;
                                this.logFileSummaries(modifiedFileSummaries);
                            }
                            Tracer.trace(Level.FINE, this.env, "splitBins = " + splitBinsThisRun + " dbClosedBins = " + dbClosedBinsThisRun + " cursorsBins = " + cursorsBinsThisRun + " nonEmptyBins = " + nonEmptyBinsThisRun + " processedBins = " + processedBinsThisRun);
                            break block45;
                        }
                        catch (DatabaseException DBE) {
                            System.err.println("INCompressor caught: " + DBE);
                            DBE.printStackTrace();
                            Object var21_27 = null;
                            if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                                throw new AssertionError();
                            }
                            this.accumulateStats(splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var21_28 = null;
                        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                            throw new AssertionError();
                        }
                        this.accumulateStats(splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
                        throw throwable;
                    }
                }
                if (Latch.countLatchesHeld() != 0) {
                    throw new AssertionError();
                }
            }
            this.accumulateStats(splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
            return;
        }
        Object var21_26 = null;
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.accumulateStats(splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
    }

    private void logFileSummaries(Set modifiedFileSummaries) throws DatabaseException {
        UtilizationProfile profile = this.env.getUtilizationProfile();
        UtilizationTracker tracker = this.env.getUtilizationTracker();
        Iterator i = modifiedFileSummaries.iterator();
        while (i.hasNext()) {
            Long fileNum = (Long)i.next();
            TrackedFileSummary trackedFile = tracker.getTrackedFile(fileNum);
            if (trackedFile == null) continue;
            profile.putFileSummary(trackedFile);
        }
    }

    private boolean isRunnable() throws DatabaseException {
        return true;
    }

    public BIN searchForBIN(DatabaseImpl db, BINReference binRef) throws DatabaseException {
        Tree tree = db.getTree();
        IN in = tree.search(binRef.getKey(), Tree.SearchType.NORMAL, -1L, null);
        if (in == null) {
            return null;
        }
        if (binRef.getData() == null) {
            return (BIN)in;
        }
        IN duplicateRoot = null;
        IN duplicateBin = null;
        BIN bin = (BIN)in;
        try {
            int index = bin.findEntry(binRef.getKey(), false, true);
            if (index >= 0) {
                if (bin.isEntryKnownDeleted(index)) {
                    bin.releaseLatch();
                    return null;
                }
                Node node = bin.fetchTarget(index);
                if (node.containsDuplicates()) {
                    duplicateRoot = (DIN)node;
                    duplicateRoot.latch();
                    bin.releaseLatch();
                    duplicateBin = (DBIN)tree.searchSubTree(duplicateRoot, binRef.getData(), Tree.SearchType.NORMAL, -1L, null);
                    return duplicateBin;
                }
                return bin;
            }
            bin.releaseLatch();
            return null;
        }
        catch (DatabaseException DBE) {
            if (bin != null && bin.getLatch().isOwner()) {
                bin.releaseLatch();
            }
            if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                duplicateRoot.releaseLatch();
            }
            if (duplicateBin != null && duplicateBin.getLatch().isOwner()) {
                duplicateBin.releaseLatch();
            }
            throw DBE;
        }
    }

    private void accumulateStats(int splitBinsThisRun, int dbClosedBinsThisRun, int cursorsBinsThisRun, int nonEmptyBinsThisRun, int processedBinsThisRun, List cursorsBinList) {
        this.splitBins += splitBinsThisRun;
        this.dbClosedBins += dbClosedBinsThisRun;
        this.cursorsBins += cursorsBinsThisRun;
        this.nonEmptyBins += nonEmptyBinsThisRun;
        this.processedBins += processedBinsThisRun;
        this.trace(Level.FINE, splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
    }

    private void trace(Level level, int splitBinsThisRun, int dbClosedBinsThisRun, int cursorsBinsThisRun, int nonEmptyBinsThisRun, int processedBinsThisRun, List cursorsBinList) {
        StringBuffer sb;
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            sb = new StringBuffer();
            sb.append(TRACE_COMPRESS);
            sb.append(" splitBins=").append(splitBinsThisRun);
            sb.append(" dbClosedBins=").append(dbClosedBinsThisRun);
            sb.append(" cursorsBins=").append(cursorsBinsThisRun);
            sb.append(" nonEmptyBins=").append(nonEmptyBinsThisRun);
            sb.append(" processedBins=").append(processedBinsThisRun);
            logger.log(level, sb.toString());
        }
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuffer();
            sb.append("cursorBinList:");
            for (int i = 0; i < cursorsBinList.size(); ++i) {
                sb.append((Long)cursorsBinList.get(i)).append(" ");
            }
            logger.log(Level.FINEST, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !INCompressor.class.desiredAssertionStatus();
    }
}

