/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class DeltaInfo
implements LogWritable,
LogReadable {
    private Key key;
    private long lsn;
    private boolean knownDeleted;

    DeltaInfo(Key key, long lsn, boolean knownDeleted) {
        this.key = key;
        this.lsn = lsn;
        this.knownDeleted = knownDeleted;
    }

    DeltaInfo() {
        this.key = new Key();
        this.lsn = -1L;
    }

    public int getLogSize() {
        return this.key.getLogSize() + LogUtils.getLongLogSize() + LogUtils.getBooleanLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.key.writeToLog(logBuffer);
        LogUtils.writeLong(logBuffer, this.lsn);
        LogUtils.writeBoolean(logBuffer, this.knownDeleted);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.key.readFromLog(itemBuffer);
        this.lsn = LogUtils.readLong(itemBuffer);
        this.knownDeleted = LogUtils.readBoolean(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        this.key.dumpLog(sb, verbose);
        sb.append(DbLsn.toString(this.lsn));
        sb.append("<knownDeleted val=\"").append(this.knownDeleted).append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    Key getKey() {
        return this.key;
    }

    boolean isKnownDeleted() {
        return this.knownDeleted;
    }

    long getLsn() {
        return this.lsn;
    }
}

