/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.EventDecoder;
import org.aesh.terminal.http.HttpDevice;
import org.aesh.terminal.io.Decoder;
import org.aesh.terminal.io.Encoder;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.tty.TtyOutputMode;

public abstract class HttpTtyConnection
implements Connection {
    public static final Size DEFAULT_SIZE = new Size(80, 24);
    private final Device device;
    private Charset charset;
    private Size size;
    private Consumer<Size> sizeHandler;
    private final EventDecoder eventDecoder;
    private final Decoder decoder;
    private final Consumer<int[]> stdout;
    private Consumer<Void> closeHandler;
    private Consumer<String> termHandler;
    private long lastAccessedTime = System.currentTimeMillis();
    private Attributes attributes;

    public HttpTtyConnection() {
        this(StandardCharsets.UTF_8, DEFAULT_SIZE);
    }

    public HttpTtyConnection(Charset charset, Size size) {
        this.charset = charset;
        this.size = size;
        this.eventDecoder = new EventDecoder(3, 4, 26);
        this.decoder = new Decoder(512, charset, (Consumer)this.eventDecoder);
        this.stdout = new TtyOutputMode((Consumer)new Encoder(charset, this::write));
        this.device = new HttpDevice("vt100");
        this.attributes = new Attributes();
    }

    public Charset outputEncoding() {
        return this.charset;
    }

    public Charset inputEncoding() {
        return this.charset;
    }

    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Device device() {
        return this.device;
    }

    protected abstract void write(byte[] var1);

    public void writeToDecoder(String msg) {
        String action;
        Map obj;
        ObjectMapper mapper = new ObjectMapper();
        try {
            obj = (Map)mapper.readValue(msg, Map.class);
            action = (String)obj.get("action");
        }
        catch (IOException e) {
            return;
        }
        if (action != null) {
            switch (action) {
                case "read": {
                    this.lastAccessedTime = System.currentTimeMillis();
                    String data = (String)obj.get("data");
                    this.decoder.write(data.getBytes());
                    break;
                }
                case "resize": {
                    try {
                        Size newSize;
                        int cols = obj.getOrDefault("cols", this.size.getWidth());
                        int rows = obj.getOrDefault("rows", this.size.getHeight());
                        if (cols <= 0 || rows <= 0 || (newSize = new Size(cols, rows)).equals((Object)this.size())) break;
                        this.size = newSize;
                        if (this.sizeHandler == null) break;
                        this.sizeHandler.accept(this.size);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Consumer<String> getTerminalTypeHandler() {
        return this.termHandler;
    }

    public void setTerminalTypeHandler(Consumer<String> handler) {
        this.termHandler = handler;
    }

    public Size size() {
        return this.size;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.eventDecoder.getSignalHandler();
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.eventDecoder.setSignalHandler(handler);
    }

    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getInputHandler();
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setInputHandler(handler);
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdout;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void openBlocking() {
    }

    public void openNonBlocking() {
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attr) {
    }

    public boolean supportsAnsi() {
        return true;
    }
}

