/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aesh.terminal.BaseDevice;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.utils.InfoCmp;

public class HttpDevice
extends BaseDevice {
    private final String type;
    private final Set<Capability> bools;
    private final Map<Capability, Integer> ints;
    private final Map<Capability, String> strings;

    public HttpDevice(String type) {
        this.type = type;
        this.bools = new HashSet<Capability>();
        this.ints = new HashMap<Capability, Integer>();
        this.strings = new HashMap<Capability, String>();
        String data = InfoCmp.getDefaultInfoCmp((String)type);
        InfoCmp.parseInfoCmp((String)data, this.bools, this.ints, this.strings);
    }

    public String type() {
        return this.type;
    }

    public boolean getBooleanCapability(Capability capability) {
        return this.bools.contains(capability);
    }

    public Integer getNumericCapability(Capability capability) {
        return this.ints.get(capability);
    }

    public String getStringCapability(Capability capability) {
        return this.strings.get(capability);
    }
}

