/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.NfsUnreachableException;
import org.hyperic.sigar.RPC;
import org.hyperic.sigar.Sigar;

public class NfsFileSystem
extends FileSystem
implements Serializable {
    private static final long serialVersionUID = 607239L;
    private static final int NFS_PROGRAM = 100003;
    String hostname = null;

    public String getHostname() {
        String dev;
        int ix;
        if (this.hostname == null && (ix = (dev = this.getDevName()).indexOf(":")) != -1) {
            String host = dev.substring(0, ix);
            try {
                InetAddress addr = InetAddress.getByName(host);
                this.hostname = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                this.hostname = host;
            }
        }
        return this.hostname;
    }

    public boolean ping() {
        return RPC.ping(this.getHostname(), 100003L) == 0;
    }

    public String getUnreachableMessage() {
        return this.getDevName() + " nfs server unreachable";
    }

    public NfsUnreachableException getUnreachableException() {
        return new NfsUnreachableException(this.getUnreachableMessage());
    }

    public static void main(String[] args) throws Exception {
        Sigar.load();
        System.out.println(RPC.ping(args[0], "nfs"));
    }
}

