/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.jmx.AbstractMBean;

public class SigarLoadAverage
extends AbstractMBean {
    private static final String MBEAN_TYPE = "LoadAverage";
    private static final double NOT_IMPLEMENTED_LOAD_VALUE = -1.0;
    private static final MBeanInfo MBEAN_INFO;
    private static final MBeanAttributeInfo MBEAN_ATTR_LAST1MIN;
    private static final MBeanAttributeInfo MBEAN_ATTR_LAST5MIN;
    private static final MBeanAttributeInfo MBEAN_ATTR_LAST15MIN;
    private static final MBeanConstructorInfo MBEAN_CONSTR_SIGAR;
    private static MBeanParameterInfo MBEAN_PARAM_SIGAR;
    private final String objectName;
    private boolean notImplemented;
    static /* synthetic */ Class class$org$hyperic$sigar$Sigar;
    static /* synthetic */ Class class$org$hyperic$sigar$jmx$SigarLoadAverage;

    public SigarLoadAverage() throws IllegalArgumentException {
        this(new Sigar());
    }

    public SigarLoadAverage(Sigar sigar) throws IllegalArgumentException {
        super(sigar, (short)0);
        this.objectName = "sigar:type=LoadAverage";
    }

    public String getObjectName() {
        return this.objectName;
    }

    public double getLastMinute() {
        try {
            return this.sigarImpl.getLoadAverage()[0];
        }
        catch (SigarNotImplementedException e) {
            return -1.0;
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public double getLastFiveMinutes() {
        try {
            return this.sigarImpl.getLoadAverage()[1];
        }
        catch (SigarNotImplementedException e) {
            return -1.0;
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public double getLast15Minutes() {
        try {
            return this.sigarImpl.getLoadAverage()[2];
        }
        catch (SigarNotImplementedException e) {
            return -1.0;
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public Object getAttribute(String attr) throws AttributeNotFoundException {
        if (MBEAN_ATTR_LAST1MIN.getName().equals(attr)) {
            return new Double(this.getLastMinute());
        }
        if (MBEAN_ATTR_LAST5MIN.getName().equals(attr)) {
            return new Double(this.getLastFiveMinutes());
        }
        if (MBEAN_ATTR_LAST15MIN.getName().equals(attr)) {
            return new Double(this.getLast15Minutes());
        }
        throw new AttributeNotFoundException(attr);
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attr.getName());
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException {
        throw new ReflectionException(new NoSuchMethodException(actionName), actionName);
    }

    public MBeanInfo getMBeanInfo() {
        return MBEAN_INFO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MBEAN_ATTR_LAST1MIN = new MBeanAttributeInfo("LastMinute", "double", "The load average in the last minute, as a fraction of 1, or -1.0 if the load cannot be determined on this platform", true, false, false);
        MBEAN_ATTR_LAST5MIN = new MBeanAttributeInfo("LastFiveMinutes", "double", "The load average over the last five minutes, as a fraction of 1, or -1.0 if the load cannot be determined on this platform", true, false, false);
        MBEAN_ATTR_LAST15MIN = new MBeanAttributeInfo("Last15Minutes", "double", "The load average over the last 15 minutes, as a fraction of 1, or -1.0 if the load cannot be determined on this platform", true, false, false);
        MBEAN_PARAM_SIGAR = new MBeanParameterInfo("sigar", (class$org$hyperic$sigar$Sigar == null ? (class$org$hyperic$sigar$Sigar = SigarLoadAverage.class$("org.hyperic.sigar.Sigar")) : class$org$hyperic$sigar$Sigar).getName(), "The Sigar instance to use to fetch data from");
        MBEAN_CONSTR_SIGAR = new MBeanConstructorInfo((class$org$hyperic$sigar$jmx$SigarLoadAverage == null ? (class$org$hyperic$sigar$jmx$SigarLoadAverage = SigarLoadAverage.class$("org.hyperic.sigar.jmx.SigarLoadAverage")) : class$org$hyperic$sigar$jmx$SigarLoadAverage).getName(), "Creates a new instance, using the Sigar instance specified to fetch the data. Fails if the CPU index is out of range.", new MBeanParameterInfo[]{MBEAN_PARAM_SIGAR});
        MBEAN_INFO = new MBeanInfo((class$org$hyperic$sigar$jmx$SigarLoadAverage == null ? (class$org$hyperic$sigar$jmx$SigarLoadAverage = SigarLoadAverage.class$("org.hyperic.sigar.jmx.SigarLoadAverage")) : class$org$hyperic$sigar$jmx$SigarLoadAverage).getName(), "Sigar load average MBean. Provides load averages of the system over the last one, five and 15 minutes. Due to the long term character of that information, the fetch is done using a Sigar proxy cache with a timeout of 30 seconds.", new MBeanAttributeInfo[]{MBEAN_ATTR_LAST1MIN, MBEAN_ATTR_LAST5MIN, MBEAN_ATTR_LAST15MIN}, new MBeanConstructorInfo[]{MBEAN_CONSTR_SIGAR}, null, null);
    }
}

