/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import java.io.FileInputStream;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;

public class RunThreadCpu {
    static Sigar sigar = new Sigar();
    static ThreadCpu cpu = new ThreadCpu();
    static int iter = 5000;

    private static long toMillis(long nano) {
        return nano / 1000000L;
    }

    private static void printTimes(long start) {
        try {
            cpu.gather(sigar, 0L);
        }
        catch (SigarException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(Thread.currentThread().getName() + ":");
        System.out.println("   real....." + (System.currentTimeMillis() - start) / 1000L);
        System.out.println("   sys......" + RunThreadCpu.toMillis(cpu.getSys()));
        System.out.println("   user....." + RunThreadCpu.toMillis(cpu.getUser()));
        System.out.println("   total...." + RunThreadCpu.toMillis(cpu.getTotal()));
    }

    private static void pause(int sec) {
        try {
            Thread.sleep(sec * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readRtJar() {
        rt = System.getProperty("java.home") + "/lib/rt.jar";
        bytes = 0;
        max = 1500000;
        is = null;
        try {
            try {
                is = new FileInputStream(new File(rt));
                while (is.read() != -1 && bytes++ <= max) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                var6_5 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (Exception e) {
                    return;
                }
            }
            var6_4 = null;
            if (is == null) return;
        }
        catch (Throwable var5_11) {
            var6_6 = null;
            if (is == null) throw var5_11;
            ** try [egrp 2[TRYBLOCK] [4 : 99->106)] { 
lbl29:
            // 1 sources

            is.close();
            throw var5_11;
lbl31:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            throw var5_11;
        }
        try {}
        catch (Exception e) {}
        is.close();
        return;
    }

    private static void scanDir() {
        for (int i = 0; i < iter; ++i) {
            String[] files = new File(".").list();
            for (int j = 0; j < files.length; ++j) {
                File f = new File(files[j]);
                f.exists();
                if (f.isDirectory()) {
                    f.list();
                }
                f.lastModified();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            iter = Integer.parseInt(args[0]);
        }
        long start = System.currentTimeMillis();
        Thread user = new Thread((Runnable)new UserThread(), "user");
        Thread read = new Thread((Runnable)new ReadThread(), "read");
        Thread scan = new Thread((Runnable)new ScanThread(), "scan");
        Thread real = new Thread((Runnable)new RealThread(), "real");
        user.start();
        read.start();
        scan.start();
        real.start();
        user.join();
        read.join();
        scan.join();
        real.join();
        RunThreadCpu.pause(3);
        RunThreadCpu.printTimes(start);
    }

    static class ScanThread
    implements Runnable {
        ScanThread() {
        }

        public void run() {
            long start = System.currentTimeMillis();
            RunThreadCpu.pause(2);
            RunThreadCpu.scanDir();
            RunThreadCpu.printTimes(start);
        }
    }

    static class ReadThread
    implements Runnable {
        ReadThread() {
        }

        public void run() {
            long start = System.currentTimeMillis();
            RunThreadCpu.pause(2);
            RunThreadCpu.readRtJar();
            RunThreadCpu.printTimes(start);
        }
    }

    static class UserThread
    implements Runnable {
        UserThread() {
        }

        public void run() {
            long start = System.currentTimeMillis();
            RunThreadCpu.pause(2);
            String s = "";
            for (int i = 0; i < iter; ++i) {
                s = s + System.getProperty("java.home");
                for (int j = 0; j < s.length(); ++j) {
                    s.charAt(j);
                }
            }
            RunThreadCpu.printTimes(start);
        }
    }

    static class RealThread
    implements Runnable {
        RealThread() {
        }

        public void run() {
            long start = System.currentTimeMillis();
            RunThreadCpu.pause(2);
            RunThreadCpu.printTimes(start);
        }
    }
}

