/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import org.hyperic.sigar.win32.EventLogRecord;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class EventLog
extends Win32 {
    int eventLogHandle = 0;
    public static final String SYSTEM = "System";
    public static final String APPLICATION = "Application";
    public static final String SECURITY = "Security";
    public static final int EVENTLOG_SUCCESS = 0;
    public static final int EVENTLOG_ERROR_TYPE = 1;
    public static final int EVENTLOG_WARNING_TYPE = 2;
    public static final int EVENTLOG_INFORMATION_TYPE = 4;
    public static final int EVENTLOG_AUDIT_SUCCESS = 8;
    public static final int EVENTLOG_AUDIT_FAILURE = 16;
    public static final int EVENTLOG_WAIT_INFINITE = -1;
    private String name;

    public void open(String name) throws Win32Exception {
        this.name = name;
        this.openlog(name);
    }

    public native void openlog(String var1) throws Win32Exception;

    public native void close() throws Win32Exception;

    public native int getNumberOfRecords() throws Win32Exception;

    public native int getOldestRecord() throws Win32Exception;

    public int getNewestRecord() throws Win32Exception {
        return this.getOldestRecord() + this.getNumberOfRecords() - 1;
    }

    public EventLogRecord read(int recordOffset) throws Win32Exception {
        EventLogRecord record = this.readlog(this.name, recordOffset);
        record.setLogName(this.name);
        return record;
    }

    private native EventLogRecord readlog(String var1, int var2) throws Win32Exception;

    public native void waitForChange(int var1) throws Win32Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String[] getLogNames() {
        void var1_2;
        String[] names;
        String EVENTLOG_KEY = "SYSTEM\\CurrentControlSet\\Services\\Eventlog";
        RegistryKey key = null;
        try {
            key = RegistryKey.LocalMachine.openSubKey("SYSTEM\\CurrentControlSet\\Services\\Eventlog");
            names = key.getSubKeyNames();
        }
        catch (Win32Exception e) {
            names = new String[]{SYSTEM, APPLICATION, SECURITY};
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
        return var1_2;
    }
}

