/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public abstract class Win32 {
    public static final String EXE_EXT = ".exe";
    private static final String EXE_EXT_U = ".exe".toUpperCase();

    public static native String findExecutable(String var0) throws SigarException;

    public static String findScriptExecutable(String name) {
        String exe;
        int ix = name.lastIndexOf(".");
        if (ix == -1) {
            return null;
        }
        String ext = name.substring(ix + 1);
        if (ext.equals("exe") || ext.equals("bat") || ext.equals("com")) {
            return null;
        }
        try {
            exe = Win32.findExecutable(new File(name).getAbsolutePath());
        }
        catch (SigarException e) {
            return null;
        }
        if (exe == null) {
            return null;
        }
        if ((exe = exe.toLowerCase()).equals(name = name.toLowerCase()) || exe.endsWith(name)) {
            return null;
        }
        File file = new File(exe);
        if (file.getName().equals("wscript.exe")) {
            exe = file.getParent() + File.separator + "cscript.exe";
        }
        return exe;
    }

    public static String[] parseCommandLine(String args) {
        ArrayList<String> res = new ArrayList<String>();
        boolean inQuote = false;
        if (args == null || (args = args.trim()).length() == 0) {
            return new String[0];
        }
        if (!args.startsWith("\"") && (args.endsWith(EXE_EXT) || args.endsWith(EXE_EXT_U)) && new File(args).exists()) {
            return new String[]{args};
        }
        StringTokenizer quoteTok = new StringTokenizer(args, "\"", true);
        while (quoteTok.hasMoreTokens()) {
            String elem = (String)quoteTok.nextElement();
            if (elem.equals("\"")) {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                res.add(elem);
                continue;
            }
            StringTokenizer spaceTok = new StringTokenizer(elem.trim());
            while (spaceTok.hasMoreTokens()) {
                res.add(spaceTok.nextToken());
            }
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unbalanced quotation marks");
        }
        return res.toArray(new String[0]);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String file = new File(args[i]).getAbsoluteFile().toString();
            String exe = Win32.findScriptExecutable(file);
            if (exe == null) continue;
            System.out.println(args[i] + "=" + exe);
        }
    }

    static {
        try {
            Sigar.load();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }
}

