/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.classic.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.db.Upgrade;
import org.jbpm.internal.log.Jdk14LogFactory;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbHelper {
    private static Log log = Log.getLog((String)DbHelper.class.getName());

    public static void initializeLogging() {
        Jdk14LogFactory.initializeJdk14Logging();
    }

    public static void printSyntax(Class<?> clazz) {
        log.info("Syntax: java -cp ... " + clazz.getName() + " database [delimiter]");
        log.info("where database is one of {oracle, postgresql, mysql, hsqldb}");
        log.info("and delimiter is the db sql delimiter.  default delimiter is ;");
    }

    public static void executeSqlResource(String resource, Session session) {
        InputStream stream = Upgrade.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new JbpmException("resource " + resource + " does not exist");
        }
        byte[] bytes = IoUtil.readBytes((InputStream)stream);
        String fileContents = new String(bytes);
        List<String> commands = DbHelper.extractCommands(fileContents);
        log.info("--- Executing DB Commands -------------------------");
        for (String command : commands) {
            log.info(command);
            try {
                int result = session.createSQLQuery(command).executeUpdate();
                log.info("--- Result: " + result + " --------------------------");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("-----------------------------------------------");
            }
        }
    }

    public static List<String> extractCommands(String fileContents) {
        ArrayList<String> commands = new ArrayList<String>();
        int i = 0;
        while (i < fileContents.length()) {
            String command;
            int j = fileContents.indexOf(";", i);
            if (j == -1) {
                j = fileContents.length();
            }
            if ((command = fileContents.substring(i, j).trim()).length() > 0) {
                commands.add(command);
            }
            i = j + 1;
        }
        return commands;
    }
}

