/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.db.DbHelper;
import org.jbpm.db.JbpmVersion;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cfg.ConfigurationImpl;
import org.jbpm.pvm.internal.id.PropertyImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;

public class Upgrade {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)Upgrade.class.getName());
    static String database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            DbHelper.printSyntax(Upgrade.class);
            return;
        }
        database = args[0];
        ProcessEngine processEngine = new ConfigurationImpl().skipDbCheck().buildProcessEngine();
        try {
            JbpmVersion jbpmVersion = (JbpmVersion)((Object)processEngine.execute((Command)new Command<Object>(){
                private static final long serialVersionUID = 1L;

                public Object execute(Environment environment) throws Exception {
                    Session session = (Session)environment.get(Session.class);
                    if (!PropertyImpl.propertiesTableExists((org.hibernate.Session)session)) {
                        try {
                            session.createSQLQuery("select CLASSNAME_ from JBPM4_VARIABLE").list();
                            return JbpmVersion.V_4_1;
                        }
                        catch (HibernateException e) {
                            return JbpmVersion.V_4_0;
                        }
                    }
                    String dbVersion = PropertyImpl.getDbVersion((org.hibernate.Session)session);
                    if (dbVersion == null) {
                        throw new JbpmException("property table exists, but no db version property is present");
                    }
                    return JbpmVersion.getJbpmVersion(dbVersion);
                }
            }));
            if (jbpmVersion == JbpmVersion.V_4_2) {
                throw new JbpmException("jBPM schema is already up to date");
            }
            if (jbpmVersion.isEarlier(JbpmVersion.V_4_1)) {
                processEngine.execute((Command)new Command<Object>(){
                    private static final long serialVersionUID = 1L;

                    public Object execute(Environment environment) throws Exception {
                        Session session = (Session)environment.get(Session.class);
                        DbHelper.executeSqlResource("upgrade-4.0-to-4.1/jbpm." + database + ".upgrade.sql", session);
                        return null;
                    }
                });
            }
            if (jbpmVersion.isEarlier(JbpmVersion.V_4_2)) {
                processEngine.execute((Command)new Command<Object>(){
                    private static final long serialVersionUID = 1L;

                    public Object execute(Environment environment) throws Exception {
                        Session session = (Session)environment.get(Session.class);
                        DbHelper.executeSqlResource("upgrade-4.1-to-4.2/jbpm." + database + ".upgrade.sql", session);
                        PropertyImpl.upgradeProperties((org.hibernate.Session)session);
                        return null;
                    }
                });
                processEngine.execute((Command)new Command<Object>(){
                    private static final long serialVersionUID = 1L;

                    public Object execute(Environment environment) throws Exception {
                        Session session = (Session)environment.get(Session.class);
                        List deploymentProperties = session.createCriteria(DeploymentProperty.class).add((Criterion)Restrictions.eq((String)"key", (Object)"pdid")).list();
                        for (DeploymentProperty deploymentProperty : deploymentProperties) {
                            String objectName = deploymentProperty.getObjectName();
                            DeploymentImpl deployment = deploymentProperty.getDeployment();
                            deployment.setProcessLanguageId(objectName, "jpdl-4.0");
                        }
                        return null;
                    }
                });
            }
            log.info("jBPM DB upgrade completed successfully.");
        }
        catch (Exception e) {
            log.error("ERROR: jBPM DB upgrade FAILED", (Throwable)e);
        }
        finally {
            processEngine.close();
        }
    }
}

