/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.test.tx;

import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.context.ThreadLocalSessionContext;


/** 
 * @author Tom Baeyens
 */
public class TxTemplate {

  private SessionFactory sessionFactory;
  
  public TxTemplate(SessionFactory sessionFactory) {
    this.sessionFactory = sessionFactory;
  }
  
  public Object execute(TxCommand txCommand) {
    Session session = sessionFactory.openSession();
    Transaction transaction = session.beginTransaction();
    ThreadLocalSessionContext.bind(session);
    try {
     return txCommand.execute(session);
    } catch (Exception e) {
      transaction.rollback();
    } finally {
      ThreadLocalSessionContext.unbind(sessionFactory);
      if (!transaction.wasRolledBack()) {
        transaction.commit();
      }
      session.close();
    }
    return null;
  }

  public void execute(VoidTxCommand voidTxCommand) {
    execute(new VoidWrapper(voidTxCommand));
  }
  
  static class VoidWrapper extends TxCommand {
    VoidTxCommand voidTxCommand;
    public VoidWrapper(VoidTxCommand voidTxCommand) {
      this.voidTxCommand = voidTxCommand;
      this.params = voidTxCommand.params;
    }
    public Object execute(org.hibernate.Session session) {
      voidTxCommand.execute(session);
      return null;
    }
  }
}
