/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.jboss5;

import java.util.ArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jbpm.integration.spi.DeploymentAdaptor;
import org.jbpm.integration.spi.DeploymentRef;
import org.jbpm.integration.spi.JBPMDeploymentMetaData;
import org.jbpm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPMDeployer
extends AbstractSimpleVFSRealDeployer<JBPMDeploymentMetaData> {
    private static final Log log = Log.getLog((String)JBPMDeployer.class.getName());
    private DeploymentAdaptor adaptor = new DeploymentAdaptor();

    public JBPMDeployer() {
        super(JBPMDeploymentMetaData.class);
    }

    public void deploy(VFSDeploymentUnit unit, JBPMDeploymentMetaData deployment) throws DeploymentException {
        log.info("Deploy " + deployment);
        deployment.setClassloader(unit.getClassLoader());
        try {
            DeploymentRef deploymentRef = this.adaptor.deploy(deployment);
            unit.addAttachment("jbpm.deployment.ref", (Object)deploymentRef);
        }
        catch (Throwable t) {
            throw new DeploymentException(t);
        }
    }

    public void undeploy(DeploymentUnit unit, JBPMDeploymentMetaData deployment) {
        log.info("Undeploy " + deployment);
        DeploymentRef deploymentRef = (DeploymentRef)unit.getAttachment("jbpm.deployment.ref");
        if (null == deploymentRef) {
            log.info("Failed to retrieve process reference information. Ignore undepoyment call: " + deployment);
            return;
        }
        ArrayList<DeploymentRef> deploymentRefs = new ArrayList<DeploymentRef>();
        deploymentRefs.add(deploymentRef);
        this.adaptor.undeploy(deploymentRefs);
    }
}

