/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;

public class Profile {
    private static final Logger logger = Logger.getLogger(Profile.class);
    private static Profile CURRENT;
    private final ProductValue product;
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();
    private final Set<Feature> previewFeatures = new HashSet<Feature>();
    private final Set<Feature> experimentalFeatures = new HashSet<Feature>();
    private final Set<Feature> deprecatedFeatures = new HashSet<Feature>();
    private final PropertyResolver propertyResolver;

    public Profile(PropertyResolver resolver) {
        this.propertyResolver = resolver;
        Config config = new Config();
        this.product = "rh-sso".equals(Version.NAME) ? ProductValue.RHSSO : ProductValue.KEYCLOAK;
        this.profile = ProfileValue.valueOf(config.getProfile().toUpperCase());
        block7: for (Feature f : Feature.values()) {
            Boolean enabled = config.getConfig(f);
            Type type = this.product.equals((Object)ProductValue.RHSSO) ? f.getTypeProduct() : f.getTypeProject();
            switch (type) {
                case DEFAULT: {
                    if (enabled == null || enabled.booleanValue()) continue block7;
                    this.disabledFeatures.add(f);
                    continue block7;
                }
                case DEPRECATED: {
                    this.deprecatedFeatures.add(f);
                }
                case DISABLED_BY_DEFAULT: {
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    if (!Type.DEPRECATED.equals((Object)type)) continue block7;
                    logger.warnf("Deprecated feature enabled: " + f.name().toLowerCase(), new Object[0]);
                    if (!Feature.UPLOAD_SCRIPTS.equals((Object)f)) continue block7;
                    this.previewFeatures.add(Feature.SCRIPTS);
                    this.disabledFeatures.remove((Object)Feature.SCRIPTS);
                    logger.warnf("Preview feature enabled: " + Feature.SCRIPTS.name().toLowerCase(), new Object[0]);
                    continue block7;
                }
                case PREVIEW: {
                    this.previewFeatures.add(f);
                    if (!(enabled != null && enabled.booleanValue() || this.profile.equals((Object)ProfileValue.PREVIEW))) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.info("Preview feature enabled: " + f.name().toLowerCase());
                    continue block7;
                }
                case EXPERIMENTAL: {
                    this.experimentalFeatures.add(f);
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.warn("Experimental feature enabled: " + f.name().toLowerCase());
                }
            }
        }
    }

    private static Profile getInstance() {
        if (CURRENT == null) {
            CURRENT = new Profile(null);
        }
        return CURRENT;
    }

    public static void init() {
        CURRENT = new Profile(null);
    }

    public static void setInstance(Profile instance) {
        CURRENT = instance;
    }

    public static String getName() {
        return Profile.getInstance().profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.getInstance().disabledFeatures;
    }

    public static Set<Feature> getPreviewFeatures() {
        return Profile.getInstance().previewFeatures;
    }

    public static Set<Feature> getExperimentalFeatures() {
        return Profile.getInstance().experimentalFeatures;
    }

    public static Set<Feature> getDeprecatedFeatures() {
        return Profile.getInstance().deprecatedFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return !Profile.getInstance().disabledFeatures.contains((Object)feature);
    }

    public static interface PropertyResolver {
        public String resolve(String var1);
    }

    private class Config {
        private Properties properties;

        public Config() {
            block14: {
                this.properties = new Properties();
                try {
                    File file;
                    String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
                    if (jbossServerConfigDir == null || !(file = new File(jbossServerConfigDir, "profile.properties")).isFile()) break block14;
                    try (FileInputStream is = new FileInputStream(file);){
                        this.properties.load(is);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String getProfile() {
            String profile = this.getProperty("keycloak.profile");
            if (profile != null) {
                return profile;
            }
            profile = this.properties.getProperty("profile");
            if (profile != null) {
                return profile;
            }
            return Version.DEFAULT_PROFILE;
        }

        public Boolean getConfig(Feature feature) {
            String config = this.getProperty("keycloak.profile.feature." + feature.name().toLowerCase());
            if (config == null) {
                config = this.properties.getProperty("feature." + feature.name().toLowerCase());
            }
            if (config == null) {
                return null;
            }
            if (config.equals("enabled")) {
                return Boolean.TRUE;
            }
            if (config.equals("disabled")) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid value for feature " + config);
        }

        private String getProperty(String name) {
            String value = System.getProperty(name);
            if (value != null) {
                return value;
            }
            if (Profile.this.propertyResolver != null) {
                return Profile.this.propertyResolver.resolve(name);
            }
            return null;
        }
    }

    private static enum ProfileValue {
        COMMUNITY,
        PRODUCT,
        PREVIEW;

    }

    private static enum ProductValue {
        KEYCLOAK,
        RHSSO;

    }

    public static enum Feature {
        ACCOUNT2(Type.DEFAULT),
        ACCOUNT_API(Type.DEFAULT),
        ADMIN_FINE_GRAINED_AUTHZ(Type.PREVIEW),
        DOCKER(Type.DISABLED_BY_DEFAULT),
        IMPERSONATION(Type.DEFAULT),
        OPENSHIFT_INTEGRATION(Type.PREVIEW),
        SCRIPTS(Type.PREVIEW),
        TOKEN_EXCHANGE(Type.PREVIEW),
        UPLOAD_SCRIPTS(Type.DEPRECATED),
        WEB_AUTHN(Type.DEFAULT, Type.PREVIEW),
        CLIENT_POLICIES(Type.PREVIEW);

        private Type typeProject;
        private Type typeProduct;

        private Feature(Type type) {
            this(type, type);
        }

        private Feature(Type typeProject, Type typeProduct) {
            this.typeProject = typeProject;
            this.typeProduct = typeProduct;
        }

        public Type getTypeProject() {
            return this.typeProject;
        }

        public Type getTypeProduct() {
            return this.typeProduct;
        }

        public boolean hasDifferentProductType() {
            return this.typeProject != this.typeProduct;
        }
    }

    public static enum Type {
        DEFAULT,
        DISABLED_BY_DEFAULT,
        PREVIEW,
        EXPERIMENTAL,
        DEPRECATED;

    }
}

