/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertRoles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesSender
extends AlertSender {
    public SenderResult send(Alert alert) {
        List<Integer> roleIds = this.getRoleIdsFromConfiguration();
        if (roleIds == null) {
            return SenderResult.getSimpleFailure((String)"No roles defined");
        }
        List<String> names = this.getRoleNames(roleIds);
        List<String> emails = this.getRoleEmails(roleIds);
        try {
            HashSet<String> uniqueEmails = new HashSet<String>(emails);
            Collection badEmails = LookupUtil.getAlertManager().sendAlertNotificationEmails(alert, uniqueEmails);
            ArrayList<String> goodEmails = new ArrayList<String>(uniqueEmails);
            goodEmails.removeAll(badEmails);
            SenderResult result = new SenderResult();
            result.setSummary("Target roles were: " + names);
            if (goodEmails.size() > 0) {
                result.addSuccessMessage("Successfully sent to: " + goodEmails);
            }
            if (badEmails.size() > 0) {
                result.addFailureMessage("Failed to send to: " + badEmails);
            }
            return result;
        }
        catch (Throwable t) {
            return SenderResult.getSimpleFailure((String)("Error sending role notifications to " + names + ", cause: " + t.getMessage()));
        }
    }

    public String previewConfiguration() {
        List<Integer> roleIds = this.getRoleIdsFromConfiguration();
        if (roleIds == null || roleIds.size() == 0) {
            return "<empty>";
        }
        List<String> names = this.getRoleNames(roleIds);
        String nameString = names.toString();
        return nameString.substring(1, nameString.length() - 1);
    }

    private List<String> getRoleNames(List<Integer> roleIds) {
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        ArrayList<String> results = new ArrayList<String>();
        for (Integer nextRoleId : roleIds) {
            Role nextRole = roleManager.getRoleById(nextRoleId);
            if (nextRole == null) continue;
            results.add(nextRole.getName());
        }
        return results;
    }

    private List<String> getRoleEmails(List<Integer> roleIds) {
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        ArrayList<String> results = new ArrayList<String>();
        for (Integer nextRoleId : roleIds) {
            Role nextRole = roleManager.getRoleById(nextRoleId);
            if (nextRole == null) continue;
            for (Subject nextSubject : nextRole.getSubjects()) {
                String nextEmail = nextSubject.getEmailAddress();
                if (nextEmail == null) continue;
                results.add(nextEmail);
            }
        }
        return results;
    }

    private List<Integer> getRoleIdsFromConfiguration() {
        PropertySimple roleIdProperty = this.alertParameters.getSimple("roleId");
        if (roleIdProperty == null) {
            return null;
        }
        String roleIdString = roleIdProperty.getStringValue();
        if (roleIdString == null || roleIdString.trim().equals("")) {
            return null;
        }
        return AlertSender.unfence((String)roleIdString, Integer.class);
    }
}

