/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Map;

public enum MultiTenancyStrategy {
    DISCRIMINATOR,
    SCHEMA,
    DATABASE,
    NONE;


    public static MultiTenancyStrategy determineMultiTenancyStrategy(Map properties) {
        Object strategy = properties.get("hibernate.multiTenancy");
        if (strategy == null) {
            return NONE;
        }
        if (MultiTenancyStrategy.class.isInstance(strategy)) {
            return (MultiTenancyStrategy)((Object)strategy);
        }
        String strategyName = strategy.toString();
        if (DISCRIMINATOR.name().equals(strategyName)) {
            return DISCRIMINATOR;
        }
        if (SCHEMA.name().equals(strategyName)) {
            return SCHEMA;
        }
        if (DATABASE.name().equals(strategyName)) {
            return DATABASE;
        }
        if (NONE.name().equals(strategyName)) {
            return NONE;
        }
        return NONE;
    }
}

