/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal.bridge;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.NoCacheProvider;
import org.hibernate.cache.internal.bridge.CollectionRegionAdapter;
import org.hibernate.cache.internal.bridge.EntityRegionAdapter;
import org.hibernate.cache.internal.bridge.QueryResultsRegionAdapter;
import org.hibernate.cache.internal.bridge.TimestampsRegionAdapter;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheProvider;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

public class RegionFactoryCacheProviderBridge
implements RegionFactory {
    public static final String DEF_PROVIDER = NoCacheProvider.class.getName();
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)RegionFactoryCacheProviderBridge.class.getName());
    private CacheProvider cacheProvider;
    private Settings settings;

    public RegionFactoryCacheProviderBridge(Properties properties) {
        String providerClassName = ConfigurationHelper.getString("hibernate.cache.provider_class", properties, DEF_PROVIDER);
        LOG.cacheProvider(providerClassName);
        try {
            this.cacheProvider = (CacheProvider)ReflectHelper.classForName(providerClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new CacheException("could not instantiate CacheProvider [" + providerClassName + "]", cnfe);
        }
    }

    @Override
    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        this.cacheProvider.start(properties);
    }

    @Override
    public void stop() {
        this.cacheProvider.stop();
        this.cacheProvider = null;
    }

    @Override
    public boolean isMinimalPutsEnabledByDefault() {
        return this.cacheProvider.isMinimalPutsEnabledByDefault();
    }

    @Override
    public AccessType getDefaultAccessType() {
        return null;
    }

    @Override
    public long nextTimestamp() {
        return this.cacheProvider.nextTimestamp();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    @Override
    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings, metadata);
    }

    @Override
    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings, metadata);
    }

    @Override
    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings);
    }

    @Override
    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings);
    }
}

