/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.search;

import org.hibernate.AnnotationException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class HibernateSearchIntegrator
implements Integrator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)HibernateSearchIntegrator.class.getName());
    public static final String AUTO_REGISTER = "hibernate.search.autoregister_listeners";
    public static final String LISTENER_CLASS = "org.hibernate.search.event.FullTextIndexEventListener";

    @Override
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean registerListeners = ConfigurationHelper.getBoolean(AUTO_REGISTER, configuration.getProperties(), false);
        if (!registerListeners) {
            LOG.debug("Skipping search event listener auto registration");
            return;
        }
        Class listenerClass = this.loadSearchEventListener(serviceRegistry);
        if (listenerClass == null) {
            LOG.debug("Skipping search event listener auto registration - could not fid listener class");
            return;
        }
        Object listener = this.instantiateListener(listenerClass);
        EventListenerRegistry listenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy(new DuplicationStrategyImpl(listenerClass));
        listenerRegistry.getEventListenerGroup(EventType.POST_INSERT).appendListener((PostInsertEventListener)listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((PostUpdateEventListener)listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_DELETE).appendListener((PostDeleteEventListener)listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).appendListener((PostCollectionRecreateEventListener)listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).appendListener((PostCollectionRemoveEventListener)listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).appendListener((PostCollectionUpdateEventListener)listener);
    }

    private Class loadSearchEventListener(SessionFactoryServiceRegistry serviceRegistry) {
        try {
            return serviceRegistry.getService(ClassLoaderService.class).classForName(LISTENER_CLASS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object instantiateListener(Class listenerClass) {
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to instantiate Search event listener", e);
        }
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public static class DuplicationStrategyImpl
    implements DuplicationStrategy {
        private final Class checkClass;

        public DuplicationStrategyImpl(Class checkClass) {
            this.checkClass = checkClass;
        }

        @Override
        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        @Override
        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

