/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public final class NonFlushedChangesImpl
implements NonFlushedChanges {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)NonFlushedChangesImpl.class.getName());
    private Map nonFlushedChangesByEntityMode = new HashMap();

    public NonFlushedChangesImpl(EventSource session) {
        this.extractFromSession(session);
    }

    @Override
    public void extractFromSession(EventSource session) {
        if (this.nonFlushedChangesByEntityMode.containsKey((Object)session.getEntityMode())) {
            throw new AssertionFailure("Already has non-flushed changes for entity mode: " + (Object)((Object)session.getEntityMode()));
        }
        this.nonFlushedChangesByEntityMode.put(session.getEntityMode(), new SessionNonFlushedChanges(session));
    }

    private SessionNonFlushedChanges getSessionNonFlushedChanges(EntityMode entityMode) {
        return (SessionNonFlushedChanges)this.nonFlushedChangesByEntityMode.get((Object)entityMode);
    }

    ActionQueue getActionQueue(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).actionQueue;
    }

    StatefulPersistenceContext getPersistenceContext(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).persistenceContext;
    }

    @Override
    public void clear() {
        this.nonFlushedChangesByEntityMode.clear();
    }

    private static class SessionNonFlushedChanges
    implements Serializable {
        private transient EntityMode entityMode;
        private transient ActionQueue actionQueue;
        private transient StatefulPersistenceContext persistenceContext;

        public SessionNonFlushedChanges(EventSource session) {
            this.entityMode = session.getEntityMode();
            this.actionQueue = session.getActionQueue();
            this.persistenceContext = (StatefulPersistenceContext)session.getPersistenceContext();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.entityMode = EntityMode.parse((String)ois.readObject());
            this.persistenceContext = StatefulPersistenceContext.deserialize(ois, null);
            this.actionQueue = ActionQueue.deserialize(ois, null);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            LOG.trace("Serializing SessionNonFlushedChanges");
            oos.defaultWriteObject();
            oos.writeObject(this.entityMode.toString());
            this.persistenceContext.serialize(oos);
            this.actionQueue.serialize(oos);
        }
    }
}

