/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.PrimaryKey;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.ValueContainer;

public abstract class AbstractTableSpecification
implements TableSpecification,
ValueContainer {
    private final LinkedHashSet<SimpleValue> values = new LinkedHashSet();
    private PrimaryKey primaryKey = new PrimaryKey(this);
    private List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();

    @Override
    public Iterable<SimpleValue> values() {
        return this.values;
    }

    @Override
    public Column createColumn(String name) {
        Column column = new Column(this, this.values.size(), name);
        this.values.add(column);
        return column;
    }

    @Override
    public DerivedValue createDerivedValue(String fragment) {
        DerivedValue value = new DerivedValue(this, this.values.size(), fragment);
        this.values.add(value);
        return value;
    }

    @Override
    public Tuple createTuple(String name) {
        return new Tuple(this, name);
    }

    @Override
    public Iterable<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public ForeignKey createForeignKey(TableSpecification targetTable, String name) {
        ForeignKey fk = new ForeignKey(this, targetTable, name);
        this.foreignKeys.add(fk);
        return fk;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }
}

