/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.List;
import java.util.Map;
import javax.persistence.DiscriminatorType;
import javax.persistence.FetchType;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.ColumnValues;
import org.hibernate.metamodel.source.annotations.entity.DiscriminatorColumnValues;
import org.hibernate.metamodel.source.annotations.entity.MappedAttribute;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class SimpleAttribute
extends MappedAttribute {
    private final boolean isId;
    private final boolean isVersioned;
    private final boolean isDiscriminator;
    private final boolean isOptimisticLockable;
    private boolean isLazy = false;
    private boolean isOptional = true;
    private PropertyGeneration propertyGeneration;
    private boolean isInsertable = true;
    private boolean isUpdatable = true;
    private final ColumnValues columnValues;

    static SimpleAttribute createSimpleAttribute(String name, String type, Map<DotName, List<AnnotationInstance>> annotations) {
        return new SimpleAttribute(name, type, annotations, false);
    }

    static SimpleAttribute createDiscriminatorAttribute(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance discriminatorOptionsAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.DISCRIMINATOR_COLUMN);
        String name = "DTYPE";
        String type = String.class.toString();
        if (discriminatorOptionsAnnotation != null) {
            name = discriminatorOptionsAnnotation.value("name").asString();
            DiscriminatorType discriminatorType = Enum.valueOf(DiscriminatorType.class, discriminatorOptionsAnnotation.value("discriminatorType").asEnum());
            switch (discriminatorType) {
                case STRING: {
                    type = String.class.toString();
                    break;
                }
                case CHAR: {
                    type = Character.class.toString();
                    break;
                }
                case INTEGER: {
                    type = Integer.class.toString();
                    break;
                }
                default: {
                    throw new AnnotationException("Unsupported discriminator type: " + discriminatorType);
                }
            }
        }
        return new SimpleAttribute(name, type, annotations, true);
    }

    SimpleAttribute(String name, String type, Map<DotName, List<AnnotationInstance>> annotations, boolean isDiscriminator) {
        super(name, type, annotations);
        this.isDiscriminator = isDiscriminator;
        AnnotationInstance idAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.ID);
        this.isId = idAnnotation != null;
        AnnotationInstance versionAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.VERSION);
        boolean bl = this.isVersioned = versionAnnotation != null;
        if (isDiscriminator) {
            this.columnValues = new DiscriminatorColumnValues(annotations);
        } else {
            AnnotationInstance columnAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.COLUMN);
            this.columnValues = new ColumnValues(columnAnnotation);
        }
        if (this.isId) {
            this.columnValues.setUnique(true);
            this.columnValues.setNullable(false);
        }
        this.isOptimisticLockable = this.checkOptimisticLockAnnotation();
        this.checkBasicAnnotation();
        this.checkGeneratedAnnotation();
    }

    public final ColumnValues getColumnValues() {
        return this.columnValues;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public boolean isDiscriminator() {
        return this.isDiscriminator;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public PropertyGeneration getPropertyGeneration() {
        return this.propertyGeneration;
    }

    public boolean isOptimisticLockable() {
        return this.isOptimisticLockable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleAttribute");
        sb.append("{isId=").append(this.isId);
        sb.append(", isVersioned=").append(this.isVersioned);
        sb.append(", isDiscriminator=").append(this.isDiscriminator);
        sb.append(", isOptimisticLockable=").append(this.isOptimisticLockable);
        sb.append(", isLazy=").append(this.isLazy);
        sb.append(", isOptional=").append(this.isOptional);
        sb.append(", propertyGeneration=").append(this.propertyGeneration);
        sb.append(", isInsertable=").append(this.isInsertable);
        sb.append(", isUpdatable=").append(this.isUpdatable);
        sb.append('}');
        return sb.toString();
    }

    private boolean checkOptimisticLockAnnotation() {
        boolean triggersVersionIncrement = true;
        AnnotationInstance optimisticLockAnnotation = this.getIfExists(HibernateDotNames.OPTIMISTIC_LOCK);
        if (optimisticLockAnnotation != null) {
            boolean exclude = optimisticLockAnnotation.value("excluded").asBoolean();
            triggersVersionIncrement = !exclude;
        }
        return triggersVersionIncrement;
    }

    private void checkBasicAnnotation() {
        AnnotationInstance basicAnnotation = this.getIfExists(JPADotNames.BASIC);
        if (basicAnnotation != null) {
            FetchType fetchType = FetchType.LAZY;
            AnnotationValue fetchValue = basicAnnotation.value("fetch");
            if (fetchValue != null) {
                fetchType = Enum.valueOf(FetchType.class, fetchValue.asEnum());
            }
            this.isLazy = fetchType == FetchType.LAZY;
            AnnotationValue optionalValue = basicAnnotation.value("optional");
            if (optionalValue != null) {
                this.isOptional = optionalValue.asBoolean();
            }
        }
    }

    private void checkGeneratedAnnotation() {
        AnnotationInstance generatedAnnotation = this.getIfExists(HibernateDotNames.GENERATED);
        if (generatedAnnotation != null) {
            GenerationTime genTime;
            this.isInsertable = false;
            AnnotationValue generationTimeValue = generatedAnnotation.value();
            if (generationTimeValue != null && GenerationTime.ALWAYS.equals((Object)(genTime = Enum.valueOf(GenerationTime.class, generationTimeValue.asEnum())))) {
                this.isUpdatable = false;
                this.propertyGeneration = PropertyGeneration.parse(genTime.toString().toLowerCase());
            }
        }
    }
}

