/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity.state.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.relational.state.ColumnRelationalState;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.entity.ColumnValues;
import org.hibernate.metamodel.source.annotations.entity.SimpleAttribute;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;

public class ColumnRelationalStateImpl
implements ColumnRelationalState {
    private final NamingStrategy namingStrategy;
    private final String columnName;
    private final boolean unique;
    private final boolean nullable;
    private final Size size;
    private final String checkCondition;
    private final String customWriteFragment;
    private final String customReadFragment;
    private final Set<String> indexes;
    private String defaultString;
    private String sqlType;
    private String comment;
    private Set<String> uniqueKeys = new HashSet<String>();

    public ColumnRelationalStateImpl(SimpleAttribute attribute, MetadataImplementor meta) {
        ColumnValues columnValues = attribute.getColumnValues();
        this.namingStrategy = meta.getOptions().getNamingStrategy();
        this.columnName = columnValues.getName().isEmpty() ? attribute.getName() : columnValues.getName();
        this.unique = columnValues.isUnique();
        this.nullable = columnValues.isNullable();
        this.size = this.createSize(columnValues.getLength(), columnValues.getScale(), columnValues.getPrecision());
        this.checkCondition = this.parseCheckAnnotation(attribute);
        this.indexes = this.parseIndexAnnotation(attribute);
        List<AnnotationInstance> columnTransformerAnnotations = this.getAllColumnTransformerAnnotations(attribute);
        String[] readWrite = this.createCustomReadWrite(columnTransformerAnnotations);
        this.customReadFragment = readWrite[0];
        this.customWriteFragment = readWrite[1];
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public String getExplicitColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public String getCheckCondition() {
        return this.checkCondition;
    }

    @Override
    public String getDefault() {
        return this.defaultString;
    }

    @Override
    public String getSqlType() {
        return this.sqlType;
    }

    @Override
    public String getCustomWriteFragment() {
        return this.customWriteFragment;
    }

    @Override
    public String getCustomReadFragment() {
        return this.customReadFragment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Set<String> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Override
    public Set<String> getIndexes() {
        return this.indexes;
    }

    private Size createSize(int length, int scale, int precision) {
        Size size = new Size();
        size.setLength(length);
        size.setScale(scale);
        size.setPrecision(precision);
        return size;
    }

    private List<AnnotationInstance> getAllColumnTransformerAnnotations(SimpleAttribute attribute) {
        AnnotationInstance columnTransformerAnnotation;
        ArrayList<AnnotationInstance> allColumnTransformerAnnotations = new ArrayList<AnnotationInstance>();
        AnnotationInstance columnTransformersAnnotations = attribute.getIfExists(HibernateDotNames.COLUMN_TRANSFORMERS);
        if (columnTransformersAnnotations != null) {
            AnnotationInstance[] annotationInstances = ((AnnotationInstance)allColumnTransformerAnnotations.get(0)).value().asNestedArray();
            allColumnTransformerAnnotations.addAll(Arrays.asList(annotationInstances));
        }
        if ((columnTransformerAnnotation = attribute.getIfExists(HibernateDotNames.COLUMN_TRANSFORMER)) != null) {
            allColumnTransformerAnnotations.add(columnTransformerAnnotation);
        }
        return allColumnTransformerAnnotations;
    }

    private String[] createCustomReadWrite(List<AnnotationInstance> columnTransformerAnnotations) {
        String[] readWrite = new String[2];
        boolean alreadyProcessedForColumn = false;
        for (AnnotationInstance annotationInstance : columnTransformerAnnotations) {
            String forColumn;
            String string = forColumn = annotationInstance.value("forColumn") == null ? null : annotationInstance.value("forColumn").asString();
            if (forColumn != null && !forColumn.equals(this.columnName)) continue;
            if (alreadyProcessedForColumn) {
                throw new AnnotationException("Multiple definition of read/write conditions for column " + this.columnName);
            }
            readWrite[0] = annotationInstance.value("read") == null ? null : annotationInstance.value("read").asString();
            readWrite[1] = annotationInstance.value("write") == null ? null : annotationInstance.value("write").asString();
            alreadyProcessedForColumn = true;
        }
        return readWrite;
    }

    private String parseCheckAnnotation(SimpleAttribute attribute) {
        String checkCondition = null;
        AnnotationInstance checkAnnotation = attribute.getIfExists(HibernateDotNames.CHECK);
        if (checkAnnotation != null) {
            checkCondition = checkAnnotation.value("constraints").toString();
        }
        return checkCondition;
    }

    private Set<String> parseIndexAnnotation(SimpleAttribute attribute) {
        HashSet<String> indexNames = new HashSet<String>();
        AnnotationInstance indexAnnotation = attribute.getIfExists(HibernateDotNames.INDEX);
        if (indexAnnotation != null) {
            String indexName = indexAnnotation.value("name").toString();
            indexNames.add(indexName);
        }
        return indexNames;
    }
}

