/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.GenerationType;
import org.hibernate.AssertionFailure;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class IdGeneratorBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)IdGeneratorBinder.class.getName());

    private IdGeneratorBinder() {
    }

    private static void addStringParameter(AnnotationInstance annotation, String element, Map<String, String> parameters, String parameter) {
        String string = JandexHelper.getValueAsString(annotation, element);
        if (StringHelper.isNotEmpty(string)) {
            parameters.put(parameter, string);
        }
    }

    public static void bind(MetadataImplementor metadata, Index jandex) {
        for (AnnotationInstance generator : jandex.getAnnotations(JPADotNames.SEQUENCE_GENERATOR)) {
            IdGeneratorBinder.bindSequenceGenerator(metadata, generator);
        }
        for (AnnotationInstance generator : jandex.getAnnotations(JPADotNames.TABLE_GENERATOR)) {
            IdGeneratorBinder.bindTableGenerator(metadata, generator);
        }
        for (AnnotationInstance generator : jandex.getAnnotations(HibernateDotNames.GENERIC_GENERATOR)) {
            IdGeneratorBinder.bindGenericGenerator(metadata, generator);
        }
        for (AnnotationInstance generators : jandex.getAnnotations(HibernateDotNames.GENERIC_GENERATORS)) {
            for (AnnotationInstance generator : JandexHelper.getValueAsArray(generators, "value")) {
                IdGeneratorBinder.bindGenericGenerator(metadata, generator);
            }
        }
    }

    private static void bindGenericGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        String name = JandexHelper.getValueAsString(generator, "name");
        HashMap<String, String> prms = new HashMap<String, String>();
        for (AnnotationInstance prm : JandexHelper.getValueAsArray(generator, "parameters")) {
            prms.put(JandexHelper.getValueAsString(prm, "name"), JandexHelper.getValueAsString(prm, "value"));
        }
        metadata.addIdGenerator(new IdGenerator(name, JandexHelper.getValueAsString(generator, "strategy"), prms));
        LOG.tracef("Add generic generator with name: %s", name);
    }

    private static void bindSequenceGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        String name = JandexHelper.getValueAsString(generator, "name");
        HashMap<String, String> prms = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(generator, "sequenceName", prms, "sequence_name");
        boolean useNewIdentifierGenerators = metadata.getOptions().useNewIdentifierGenerators();
        String strategy = IdGeneratorBinder.generatorType(GenerationType.SEQUENCE, useNewIdentifierGenerators);
        if (useNewIdentifierGenerators) {
            IdGeneratorBinder.addStringParameter(generator, "catalog", prms, "catalog");
            IdGeneratorBinder.addStringParameter(generator, "schema", prms, "schema");
            prms.put("increment_size", String.valueOf(JandexHelper.getValueAsInt(generator, "allocationSize")));
            prms.put("initial_value", String.valueOf(JandexHelper.getValueAsInt(generator, "initialValue")));
        } else {
            if (JandexHelper.getValueAsInt(generator, "initialValue") != 1) {
                LOG.unsupportedInitialValue("hibernate.id.new_generator_mappings");
            }
            prms.put("max_lo", String.valueOf(JandexHelper.getValueAsInt(generator, "allocationSize") - 1));
        }
        metadata.addIdGenerator(new IdGenerator(name, strategy, prms));
        LOG.tracef("Add sequence generator with name: %s", name);
    }

    private static void bindTableGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        String name = JandexHelper.getValueAsString(generator, "name");
        HashMap<String, String> prms = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(generator, "catalog", prms, "catalog");
        IdGeneratorBinder.addStringParameter(generator, "schema", prms, "schema");
        boolean useNewIdentifierGenerators = metadata.getOptions().useNewIdentifierGenerators();
        String strategy = IdGeneratorBinder.generatorType(GenerationType.TABLE, useNewIdentifierGenerators);
        if (useNewIdentifierGenerators) {
            prms.put("prefer_entity_table_as_segment_value", "true");
            IdGeneratorBinder.addStringParameter(generator, "table", prms, "table_name");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnName", prms, "segment_column_name");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnValue", prms, "segment_value");
            IdGeneratorBinder.addStringParameter(generator, "valueColumnName", prms, "value_column_name");
            prms.put("increment_size", String.valueOf(JandexHelper.getValueAsInt(generator, "allocationSize")));
            prms.put("initial_value", String.valueOf(JandexHelper.getValueAsInt(generator, "initialValue") + 1));
        } else {
            IdGeneratorBinder.addStringParameter(generator, "table", prms, "table");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnName", prms, "primary_key_column");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnValue", prms, "primary_key_value");
            IdGeneratorBinder.addStringParameter(generator, "valueColumnName", prms, "value_column");
            prms.put("max_lo", String.valueOf(JandexHelper.getValueAsInt(generator, "allocationSize") - 1));
        }
        if (JandexHelper.getValueAsArray(generator, "uniqueConstraints").length > 0) {
            LOG.ignoringTableGeneratorConstraints(name);
        }
        metadata.addIdGenerator(new IdGenerator(name, strategy, prms));
        LOG.tracef("Add table generator with name: %s", name);
    }

    public static String generatorType(GenerationType generatorEnum, boolean useNewGeneratorMappings) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "native";
            }
            case TABLE: {
                return useNewGeneratorMappings ? "enhanced-table" : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }
}

