/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotation.xml.XMLAccessType;
import org.hibernate.metamodel.source.annotation.xml.XMLAttributes;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityListeners;
import org.hibernate.metamodel.source.annotation.xml.XMLIdClass;
import org.hibernate.metamodel.source.annotation.xml.XMLPostLoad;
import org.hibernate.metamodel.source.annotation.xml.XMLPostPersist;
import org.hibernate.metamodel.source.annotation.xml.XMLPostRemove;
import org.hibernate.metamodel.source.annotation.xml.XMLPostUpdate;
import org.hibernate.metamodel.source.annotation.xml.XMLPrePersist;
import org.hibernate.metamodel.source.annotation.xml.XMLPreRemove;
import org.hibernate.metamodel.source.annotation.xml.XMLPreUpdate;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractAttributesBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.AccessHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.AnnotationMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.AttributesBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.ListenerMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

abstract class AbstractEntityObjectMocker
extends AnnotationMocker {
    private ListenerMocker listenerParser;
    protected AbstractAttributesBuilder attributesBuilder;
    protected ClassInfo classInfo;
    private boolean isPreProcessCalled = false;

    AbstractEntityObjectMocker(IndexBuilder indexBuilder, EntityMappingsMocker.Default defaults) {
        super(indexBuilder, defaults);
    }

    final void preProcess() {
        this.applyDefaults();
        this.classInfo = this.indexBuilder.createClassInfo(this.getClassName());
        DotName classDotName = this.classInfo.name();
        if (this.isMetadataComplete()) {
            this.indexBuilder.metadataComplete(classDotName);
        }
        this.parserAccessType(this.getAccessType(), this.getTarget());
        this.isPreProcessCalled = true;
    }

    @Override
    final void process() {
        if (!this.isPreProcessCalled) {
            throw new AssertionFailure("preProcess should be called before process");
        }
        if (this.getAccessType() == null) {
            XMLAccessType accessType = AccessHelper.getEntityAccess(this.getTargetName(), this.indexBuilder);
            if (accessType == null) {
                accessType = this.getDefaults().getAccess();
            }
            this.parserAccessType(accessType, this.getTarget());
        }
        this.processExtra();
        if (this.isExcludeDefaultListeners()) {
            this.create(EXCLUDE_DEFAULT_LISTENERS);
        }
        if (this.isExcludeSuperclassListeners()) {
            this.create(EXCLUDE_SUPERCLASS_LISTENERS);
        }
        this.parserIdClass(this.getIdClass());
        if (this.getAttributes() != null) {
            this.getAttributesBuilder().parser();
        }
        if (this.getEntityListeners() != null) {
            this.getListenerParser().parser(this.getEntityListeners());
        }
        this.getListenerParser().parser(this.getPrePersist());
        this.getListenerParser().parser(this.getPreRemove());
        this.getListenerParser().parser(this.getPreUpdate());
        this.getListenerParser().parser(this.getPostPersist());
        this.getListenerParser().parser(this.getPostUpdate());
        this.getListenerParser().parser(this.getPostRemove());
        this.getListenerParser().parser(this.getPostLoad());
        this.indexBuilder.finishEntityObject(this.getTargetName(), this.getDefaults());
    }

    protected abstract void processExtra();

    protected abstract void applyDefaults();

    protected abstract boolean isMetadataComplete();

    protected abstract boolean isExcludeDefaultListeners();

    protected abstract boolean isExcludeSuperclassListeners();

    protected abstract XMLIdClass getIdClass();

    protected abstract XMLEntityListeners getEntityListeners();

    protected abstract XMLAccessType getAccessType();

    protected abstract String getClassName();

    protected abstract XMLPrePersist getPrePersist();

    protected abstract XMLPreRemove getPreRemove();

    protected abstract XMLPreUpdate getPreUpdate();

    protected abstract XMLPostPersist getPostPersist();

    protected abstract XMLPostUpdate getPostUpdate();

    protected abstract XMLPostRemove getPostRemove();

    protected abstract XMLPostLoad getPostLoad();

    protected abstract XMLAttributes getAttributes();

    protected ListenerMocker getListenerParser() {
        if (this.listenerParser == null) {
            this.listenerParser = new ListenerMocker(this.indexBuilder, this.classInfo);
        }
        return this.listenerParser;
    }

    protected AbstractAttributesBuilder getAttributesBuilder() {
        if (this.attributesBuilder == null) {
            this.attributesBuilder = new AttributesBuilder(this.indexBuilder, this.classInfo, this.getAccessType(), this.getDefaults(), this.getAttributes());
        }
        return this.attributesBuilder;
    }

    protected AnnotationInstance parserIdClass(XMLIdClass idClass) {
        if (idClass == null) {
            return null;
        }
        String className = MockHelper.buildSafeClassName(idClass.getClazz(), this.getDefaults().getPackageName());
        return this.create(ID_CLASS, MockHelper.classValueArray("value", className, this.indexBuilder.getServiceRegistry()));
    }

    @Override
    protected DotName getTargetName() {
        return this.classInfo.name();
    }

    @Override
    protected AnnotationTarget getTarget() {
        return this.classInfo;
    }
}

