/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.source.annotation.xml.XMLAccessType;
import org.hibernate.metamodel.source.annotation.xml.XMLEnumType;
import org.hibernate.metamodel.source.annotation.xml.XMLMapKey;
import org.hibernate.metamodel.source.annotation.xml.XMLMapKeyClass;
import org.hibernate.metamodel.source.annotation.xml.XMLMapKeyColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLMapKeyJoinColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLTemporalType;
import org.hibernate.metamodel.source.annotations.xml.mocker.AccessHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.AnnotationMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

abstract class PropertyMocker
extends AnnotationMocker {
    protected ClassInfo classInfo;
    private AnnotationTarget target;

    PropertyMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults) {
        super(indexBuilder, defaults);
        this.classInfo = classInfo;
    }

    protected abstract void processExtra();

    protected abstract String getFieldName();

    protected abstract XMLAccessType getAccessType();

    protected abstract void setAccessType(XMLAccessType var1);

    @Override
    protected DotName getTargetName() {
        return this.classInfo.name();
    }

    protected void resolveTarget() {
        XMLAccessType accessType = this.getAccessType();
        if (accessType == null) {
            accessType = AccessHelper.getAccessFromAttributeAnnotation(this.getTargetName(), this.getFieldName(), this.indexBuilder);
            if (accessType == null) {
                accessType = AccessHelper.getEntityAccess(this.getTargetName(), this.indexBuilder);
            }
            if (accessType == null) {
                accessType = AccessHelper.getAccessFromIdPosition(this.getTargetName(), this.indexBuilder);
            }
            if (accessType == null) {
                accessType = AccessHelper.getAccessFromDefault(this.indexBuilder);
            }
            if (accessType == null) {
                accessType = XMLAccessType.PROPERTY;
            }
            this.setAccessType(accessType);
        }
    }

    @Override
    protected AnnotationTarget getTarget() {
        if (this.target == null) {
            this.target = this.getTargetFromAttributeAccessType(this.getAccessType());
        }
        return this.target;
    }

    protected AnnotationTarget getTargetFromAttributeAccessType(XMLAccessType accessType) {
        if (accessType == null) {
            throw new IllegalArgumentException("access type can't be null.");
        }
        switch (accessType) {
            case FIELD: {
                return MockHelper.getTarget(this.indexBuilder.getServiceRegistry(), this.classInfo, this.getFieldName(), MockHelper.TargetType.FIELD);
            }
            case PROPERTY: {
                return MockHelper.getTarget(this.indexBuilder.getServiceRegistry(), this.classInfo, this.getFieldName(), MockHelper.TargetType.PROPERTY);
            }
        }
        throw new HibernateException("can't determin access type [" + (Object)((Object)accessType) + "]");
    }

    @Override
    final void process() {
        this.resolveTarget();
        this.processExtra();
    }

    protected AnnotationInstance parserMapKeyColumn(XMLMapKeyColumn mapKeyColumn, AnnotationTarget target) {
        if (mapKeyColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", mapKeyColumn.getName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", mapKeyColumn.getColumnDefinition(), annotationValueList);
        MockHelper.stringValue("table", mapKeyColumn.getTable(), annotationValueList);
        MockHelper.booleanValue("nullable", mapKeyColumn.isNullable(), annotationValueList);
        MockHelper.booleanValue("insertable", mapKeyColumn.isInsertable(), annotationValueList);
        MockHelper.booleanValue("updatable", mapKeyColumn.isUpdatable(), annotationValueList);
        MockHelper.booleanValue("unique", mapKeyColumn.isUnique(), annotationValueList);
        MockHelper.integerValue("length", mapKeyColumn.getLength(), annotationValueList);
        MockHelper.integerValue("precision", mapKeyColumn.getPrecision(), annotationValueList);
        MockHelper.integerValue("scale", mapKeyColumn.getScale(), annotationValueList);
        return this.create(MAP_KEY_COLUMN, target, annotationValueList);
    }

    protected AnnotationInstance parserMapKeyClass(XMLMapKeyClass mapKeyClass, AnnotationTarget target) {
        if (mapKeyClass == null) {
            return null;
        }
        return this.create(MAP_KEY_CLASS, target, MockHelper.classValueArray("value", mapKeyClass.getClazz(), this.indexBuilder.getServiceRegistry()));
    }

    protected AnnotationInstance parserMapKeyTemporal(XMLTemporalType temporalType, AnnotationTarget target) {
        if (temporalType == null) {
            return null;
        }
        return this.create(MAP_KEY_TEMPORAL, target, MockHelper.enumValueArray("value", TEMPORAL_TYPE, temporalType));
    }

    protected AnnotationInstance parserMapKeyEnumerated(XMLEnumType enumType, AnnotationTarget target) {
        if (enumType == null) {
            return null;
        }
        return this.create(MAP_KEY_ENUMERATED, target, MockHelper.enumValueArray("value", ENUM_TYPE, enumType));
    }

    protected AnnotationInstance parserMapKey(XMLMapKey mapKey, AnnotationTarget target) {
        if (mapKey == null) {
            return null;
        }
        return this.create(MAP_KEY, target, MockHelper.stringValueArray("name", mapKey.getName()));
    }

    private AnnotationValue[] nestedMapKeyJoinColumnList(String name, List<XMLMapKeyJoinColumn> columns, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(columns)) {
            AnnotationValue[] values = new AnnotationValue[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserMapKeyJoinColumn(columns.get(i), null);
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
            return values;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected AnnotationInstance parserMapKeyJoinColumnList(List<XMLMapKeyJoinColumn> joinColumnList, AnnotationTarget target) {
        if (MockHelper.isNotEmpty(joinColumnList)) {
            if (joinColumnList.size() == 1) {
                return this.parserMapKeyJoinColumn(joinColumnList.get(0), target);
            }
            AnnotationValue[] values = this.nestedMapKeyJoinColumnList("value", joinColumnList, null);
            return this.create(MAP_KEY_JOIN_COLUMNS, target, values);
        }
        return null;
    }

    private AnnotationInstance parserMapKeyJoinColumn(XMLMapKeyJoinColumn column, AnnotationTarget target) {
        if (column == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", column.getName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", column.getColumnDefinition(), annotationValueList);
        MockHelper.stringValue("table", column.getTable(), annotationValueList);
        MockHelper.stringValue("referencedColumnName", column.getReferencedColumnName(), annotationValueList);
        MockHelper.booleanValue("unique", column.isUnique(), annotationValueList);
        MockHelper.booleanValue("nullable", column.isNullable(), annotationValueList);
        MockHelper.booleanValue("insertable", column.isInsertable(), annotationValueList);
        MockHelper.booleanValue("updatable", column.isUpdatable(), annotationValueList);
        return this.create(MAP_KEY_JOIN_COLUMN, target, annotationValueList);
    }
}

