/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.CollectionElementType;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.relational.state.TupleRelationalState;
import org.hibernate.metamodel.relational.state.ValueRelationalState;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.state.binding.HbmEntityBindingState;
import org.hibernate.metamodel.source.hbm.state.binding.HbmManyToOneAttributeBindingState;
import org.hibernate.metamodel.source.hbm.state.binding.HbmPluralAttributeBindingState;
import org.hibernate.metamodel.source.hbm.state.binding.HbmSimpleAttributeBindingState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmManyToOneRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.state.relational.HbmSimpleValueRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLAnyElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLBagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLComponentElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLDynamicComponentElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLFilterElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLIdbagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinedSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLListElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLMapElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLOneToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertiesElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLResultsetElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSetElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLTuplizerElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLUnionSubclassElement;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MetadataImplementor;

abstract class AbstractEntityBinder {
    private final HbmBindingContext bindingContext;
    private final Schema.Name schemaName;

    AbstractEntityBinder(HbmBindingContext bindingContext, XMLHibernateMapping.XMLClass entityClazz) {
        this.bindingContext = bindingContext;
        this.schemaName = new Schema.Name(entityClazz.getSchema() == null ? bindingContext.getMappingDefaults().getSchemaName() : entityClazz.getSchema(), entityClazz.getCatalog() == null ? bindingContext.getMappingDefaults().getCatalogName() : entityClazz.getCatalog());
    }

    public boolean isRoot() {
        return false;
    }

    public abstract InheritanceType getInheritanceType();

    public HbmBindingContext getBindingContext() {
        return this.bindingContext;
    }

    protected MetadataImplementor getMetadata() {
        return this.bindingContext.getMetadataImplementor();
    }

    protected Schema.Name getSchemaName() {
        return this.schemaName;
    }

    protected NamingStrategy getNamingStrategy() {
        return this.getMetadata().getOptions().getNamingStrategy();
    }

    protected void basicEntityBinding(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, Hierarchical superType) {
        entityBinding.setEntity(new Entity(this.bindingContext.extractEntityName(entityClazz), superType));
        entityBinding.initialize(new HbmEntityBindingState(this.isRoot(), this.getInheritanceType(), this.bindingContext, entityClazz));
        this.bindPojoRepresentation(entityClazz, entityBinding);
        this.bindDom4jRepresentation(entityClazz, entityBinding);
        this.bindMapRepresentation(entityClazz, entityBinding);
        String entityName = entityBinding.getEntity().getName();
        if (entityClazz.getFetchProfile() != null) {
            this.bindingContext.bindFetchProfiles(entityClazz.getFetchProfile(), entityName);
        }
        this.getMetadata().addImport(entityName, entityName);
        if (this.bindingContext.isAutoImport() && entityName.indexOf(46) > 0) {
            this.getMetadata().addImport(StringHelper.unqualify(entityName), entityName);
        }
    }

    protected String getDefaultAccess() {
        return this.bindingContext.getMappingDefaults().getPropertyAccessorName();
    }

    private void bindPojoRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        String className = this.bindingContext.getClassName(entityClazz.getName());
        String proxyName = entityBinding.getProxyInterfaceName();
        entityBinding.getEntity().getPojoEntitySpecifics().setClassName(className);
        if (proxyName != null) {
            entityBinding.getEntity().getPojoEntitySpecifics().setProxyInterfaceName(proxyName);
            entityBinding.setLazy(true);
        } else if (entityBinding.isLazy()) {
            entityBinding.getEntity().getPojoEntitySpecifics().setProxyInterfaceName(className);
        }
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.POJO);
        if (tuplizer != null) {
            entityBinding.getEntity().getPojoEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private void bindDom4jRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        String nodeName = entityClazz.getNode();
        if (nodeName == null) {
            nodeName = StringHelper.unqualify(entityBinding.getEntity().getName());
        }
        entityBinding.getEntity().getDom4jEntitySpecifics().setNodeName(nodeName);
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.DOM4J);
        if (tuplizer != null) {
            entityBinding.getEntity().getDom4jEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private void bindMapRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.MAP);
        if (tuplizer != null) {
            entityBinding.getEntity().getMapEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private static XMLTuplizerElement locateTuplizerDefinition(XMLHibernateMapping.XMLClass container, EntityMode entityMode) {
        for (XMLTuplizerElement tuplizer : container.getTuplizer()) {
            if (!entityMode.toString().equals(tuplizer.getEntityMode())) continue;
            return tuplizer;
        }
        return null;
    }

    protected String getClassTableName(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, Table denormalizedSuperTable) {
        String physicalTableName;
        String entityName = entityBinding.getEntity().getName();
        if (entityClazz.getTable() == null) {
            String logicalTableName = StringHelper.unqualify(entityName);
            physicalTableName = this.getMetadata().getOptions().getNamingStrategy().classToTableName(entityName);
        } else {
            String logicalTableName = entityClazz.getTable();
            physicalTableName = this.getMetadata().getOptions().getNamingStrategy().tableName(logicalTableName);
        }
        return physicalTableName;
    }

    protected void buildAttributeBindings(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        this.buildAttributeBindings(entityClazz, entityBinding, null, true, true);
    }

    protected void buildAttributeBindings(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, UniqueKey uniqueKey, boolean mutable, boolean nullable) {
        boolean naturalId = uniqueKey != null;
        String entiytName = entityBinding.getEntity().getName();
        TableSpecification tabe = entityBinding.getBaseTable();
        AbstractAttributeBinding attributeBinding = null;
        for (Object object : entityClazz.getPropertyOrManyToOneOrOneToOne()) {
            Object collection;
            if (XMLBagElement.class.isInstance(object)) {
                collection = (XMLBagElement)XMLBagElement.class.cast(object);
                BagBinding collectionBinding = this.makeBagAttributeBinding((XMLBagElement)collection, entityBinding);
                this.bindingContext.getMetadataImplementor().addCollection(collectionBinding);
                attributeBinding = collectionBinding;
                continue;
            }
            if (XMLIdbagElement.class.isInstance(object)) {
                collection = (XMLIdbagElement)XMLIdbagElement.class.cast(object);
                continue;
            }
            if (XMLSetElement.class.isInstance(object)) {
                collection = (XMLSetElement)XMLSetElement.class.cast(object);
                continue;
            }
            if (XMLListElement.class.isInstance(object)) {
                collection = (XMLListElement)XMLListElement.class.cast(object);
                continue;
            }
            if (XMLMapElement.class.isInstance(object)) {
                collection = (XMLMapElement)XMLMapElement.class.cast(object);
                continue;
            }
            if (XMLManyToOneElement.class.isInstance(object)) {
                XMLManyToOneElement manyToOne = (XMLManyToOneElement)XMLManyToOneElement.class.cast(object);
                attributeBinding = this.makeManyToOneAttributeBinding(manyToOne, entityBinding);
                continue;
            }
            if (XMLAnyElement.class.isInstance(object) || XMLOneToOneElement.class.isInstance(object)) continue;
            if (XMLPropertyElement.class.isInstance(object)) {
                XMLPropertyElement property = (XMLPropertyElement)XMLPropertyElement.class.cast(object);
                attributeBinding = this.bindProperty(property, entityBinding);
                continue;
            }
            if (!XMLComponentElement.class.isInstance(object) && !XMLDynamicComponentElement.class.isInstance(object) && !XMLPropertiesElement.class.isInstance(object)) continue;
        }
        for (XMLJoinElement xMLJoinElement : entityClazz.getJoin()) {
        }
        for (XMLSubclassElement xMLSubclassElement : entityClazz.getSubclass()) {
        }
        for (XMLJoinedSubclassElement xMLJoinedSubclassElement : entityClazz.getJoinedSubclass()) {
        }
        for (XMLUnionSubclassElement xMLUnionSubclassElement : entityClazz.getUnionSubclass()) {
        }
        for (XMLFilterElement xMLFilterElement : entityClazz.getFilter()) {
        }
        if (entityClazz.getNaturalId() != null) {
            // empty if block
        }
        if (entityClazz.getQueryOrSqlQuery() != null) {
            for (Object object : entityClazz.getQueryOrSqlQuery()) {
                if (!XMLQueryElement.class.isInstance(object) && !XMLSqlQueryElement.class.isInstance(object)) continue;
            }
        }
        if (entityClazz.getResultset() != null) {
            for (XMLResultsetElement xMLResultsetElement : entityClazz.getResultset()) {
            }
        }
    }

    protected SimpleAttributeBinding bindProperty(XMLPropertyElement property, EntityBinding entityBinding) {
        HbmSimpleAttributeBindingState bindingState = new HbmSimpleAttributeBindingState(entityBinding.getEntity().getPojoEntitySpecifics().getClassName(), (BindingContext)this.bindingContext, entityBinding.getMetaAttributeContext(), property);
        ValueRelationalState relationalState = AbstractEntityBinder.convertToSimpleValueRelationalStateIfPossible(new HbmSimpleValueRelationalStateContainer((BindingContext)this.bindingContext, true, property));
        entityBinding.getEntity().getOrCreateSingularAttribute(bindingState.getAttributeName());
        return entityBinding.makeSimpleAttributeBinding(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalState);
    }

    protected static ValueRelationalState convertToSimpleValueRelationalStateIfPossible(ValueRelationalState state) {
        if (!TupleRelationalState.class.isInstance(state)) {
            return state;
        }
        TupleRelationalState tupleRelationalState = (TupleRelationalState)TupleRelationalState.class.cast(state);
        return tupleRelationalState.getRelationalStates().size() == 1 ? (ValueRelationalState)tupleRelationalState.getRelationalStates().get(0) : state;
    }

    protected BagBinding makeBagAttributeBinding(XMLBagElement collection, EntityBinding entityBinding) {
        HbmPluralAttributeBindingState bindingState = new HbmPluralAttributeBindingState(entityBinding.getEntity().getPojoEntitySpecifics().getClassName(), this.bindingContext, entityBinding.getMetaAttributeContext(), collection);
        BagBinding collectionBinding = entityBinding.makeBagAttributeBinding(bindingState.getAttributeName(), this.getCollectionElementType(collection)).initialize(bindingState);
        return collectionBinding;
    }

    private CollectionElementType getCollectionElementType(XMLBagElement collection) {
        if (collection.getElement() != null) {
            return CollectionElementType.BASIC;
        }
        if (collection.getCompositeElement() != null) {
            return CollectionElementType.COMPOSITE;
        }
        if (collection.getManyToMany() != null) {
            return CollectionElementType.MANY_TO_MANY;
        }
        if (collection.getOneToMany() != null) {
            return CollectionElementType.ONE_TO_MANY;
        }
        if (collection.getManyToAny() != null) {
            return CollectionElementType.MANY_TO_ANY;
        }
        throw new AssertionFailure("Unknown collection element type: " + collection);
    }

    private ManyToOneAttributeBinding makeManyToOneAttributeBinding(XMLManyToOneElement manyToOne, EntityBinding entityBinding) {
        HbmManyToOneAttributeBindingState bindingState = new HbmManyToOneAttributeBindingState(entityBinding.getEntity().getPojoEntitySpecifics().getClassName(), this.bindingContext, entityBinding.getMetaAttributeContext(), manyToOne);
        HbmManyToOneRelationalStateContainer relationalState = new HbmManyToOneRelationalStateContainer((BindingContext)this.bindingContext, true, manyToOne);
        entityBinding.getEntity().getOrCreateSingularAttribute(bindingState.getAttributeName());
        ManyToOneAttributeBinding manyToOneAttributeBinding = entityBinding.makeManyToOneAttributeBinding(bindingState.getAttributeName()).initialize(bindingState).initialize(relationalState);
        return manyToOneAttributeBinding;
    }
}

